/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.tools.Pickaxe;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.ubb.UltraBlock;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class ChainReaction
extends Talent {
    private static String name = "ChainReaction";
    private static String description = "Break ore veins when breaking a single ore with a pickaxe.";
    private static String tree = "Mining";
    private static int requiredLevel = 20;
    private static Material icon = Material.CHAIN;
    private static int slot = 20;
    public static final Set<Material> ORES = EnumSet.of(Material.COAL_ORE, new Material[]{Material.COPPER_ORE, Material.LAPIS_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.REDSTONE_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.ANCIENT_DEBRIS, Material.BONE_BLOCK});

    public ChainReaction() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new ChainReaction(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player p = event.getPlayer();
        ItemStack tool = p.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        Material m = block.getType();
        if (!Pickaxe.isPickaxe(tool)) {
            return;
        }
        if (!ChainReaction.hasAbility(p)) {
            return;
        }
        if (p.isSneaking()) {
            return;
        }
        if (!ORES.contains(m)) {
            return;
        }
        UltraBlock.breakBlocks(ChainReaction.getVeinBlocks(block), p);
    }

    public static ArrayList<ArrayList<Block>> getVeinBlocks(Block startBlock) {
        ArrayList<ArrayList<Block>> veinBlocksByLayer = new ArrayList<ArrayList<Block>>();
        HashSet<Block> visitedBlocks = new HashSet<Block>();
        Material startType = startBlock.getType();
        if (!ORES.contains(startType)) {
            return veinBlocksByLayer;
        }
        ChainReaction.findVeinBlocksRecursively(startBlock, startType, veinBlocksByLayer, visitedBlocks, startBlock.getLocation());
        veinBlocksByLayer.remove(0);
        return veinBlocksByLayer;
    }

    private static void findVeinBlocksRecursively(Block currentBlock, Material targetType, ArrayList<ArrayList<Block>> veinBlocksByLayer, HashSet<Block> visitedBlocks, Location sourceLocation) {
        if (visitedBlocks.contains(currentBlock)) {
            return;
        }
        visitedBlocks.add(currentBlock);
        if (currentBlock.getType() == targetType) {
            int distance = (int)Math.round(currentBlock.getLocation().distance(sourceLocation));
            while (veinBlocksByLayer.size() <= distance) {
                veinBlocksByLayer.add(new ArrayList());
            }
            veinBlocksByLayer.get(distance).add(currentBlock);
            DebugUtility.consoleMessage("chain reaction breaking " + currentBlock.getType().name());
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        Block adjacentBlock = currentBlock.getRelative(x, y, z);
                        ChainReaction.findVeinBlocksRecursively(adjacentBlock, targetType, veinBlocksByLayer, visitedBlocks, sourceLocation);
                    }
                }
            }
        }
    }
}

