/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;

public class CaveDweller
extends Talent {
    private static String name = "CaveDweller";
    private static String description = "Gain night vision when not exposed to the surface; when exposed to sunlight gain the hunger effect and blindness for 10 seconds or until you return to underground (no effects while above ground at night or during storm).";
    private static String tree = "Mining";
    private static int requiredLevel = 28;
    private static Material icon = Material.SPIDER_EYE;
    private static int slot = 28;

    public CaveDweller() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new CaveDweller(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        CaveDweller.scheduler();
    }

    public static void scheduler() {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), () -> {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                int y = p.getLocation().getBlockY();
                if (CaveDweller.hasAbility(p) && y < 64 && p.getLocation().getBlock().getLightFromSky() < 11) {
                    p.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 1200, 1));
                    AbilityManager.putCooldown(p, name, 3000);
                    continue;
                }
                if (!CaveDweller.hasAbility(p) || AbilityManager.isOffCooldown(p, name) || p.getLocation().getBlock().getLightFromSky() <= 11 || !p.getWorld().isDayTime() && p.getWorld().hasStorm()) continue;
                p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 1));
                p.removePotionEffect(PotionEffectType.NIGHT_VISION);
            }
        }, 0L, 80L);
    }
}

