/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.util.ArrayList;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import me.ultra42.ultraskills.utilities.ubb.UltraBlock;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Boring
extends Talent {
    private static String name = "Boring";
    private static String description = "MINING MODE: Upon mining a block with a pickaxe from the side, bores a tunnel. Tunnel size scales with pickaxe material. (Press the swap item button to change mining modes; default is F)";
    private static String tree = "Mining";
    private static int requiredLevel = 30;
    private static Material icon = Material.IRON_PICKAXE;
    private static int slot = 30;

    public Boring() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Boring(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void cast(BlockBreakEvent e, boolean isSecondary) {
        Block b = e.getBlock();
        Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        String face = PersistentDataUtility.readString((Entity)p, "mining_face", BlockFace.SELF.name());
        if (face.equals("DOWN") || face.equals("UP") || face.equals("SELF")) {
            return;
        }
        if (!Boring.isEyeLevel(b, p)) {
            return;
        }
        ArrayList<Block> phase1 = new ArrayList<Block>();
        ArrayList<Block> phase2 = new ArrayList<Block>();
        ArrayList<ArrayList<Block>> blocks = new ArrayList<ArrayList<Block>>();
        blocks.add(phase1);
        blocks.add(phase2);
        phase1.add(b.getRelative(BlockFace.UP));
        phase1.add(b.getRelative(BlockFace.DOWN));
        if (face.equals("EAST") || face.equals("WEST")) {
            phase1.add(b.getRelative(BlockFace.NORTH));
            phase1.add(b.getRelative(BlockFace.SOUTH));
            phase2.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP));
            phase2.add(b.getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN));
            phase2.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP));
            phase2.add(b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN));
        } else if (face.equals("NORTH") || face.equals("SOUTH")) {
            phase1.add(b.getRelative(BlockFace.EAST));
            phase1.add(b.getRelative(BlockFace.WEST));
            phase2.add(b.getRelative(BlockFace.EAST).getRelative(BlockFace.UP));
            phase2.add(b.getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN));
            phase2.add(b.getRelative(BlockFace.WEST).getRelative(BlockFace.UP));
            phase2.add(b.getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN));
        }
        p.playSound(p.getLocation(), Sound.BLOCK_SHROOMLIGHT_PLACE, 1.0f, 0.5f);
        UltraBlock.breakBlocks(blocks, p);
    }

    public static boolean isEyeLevel(Block block, Player player) {
        int blockY;
        int playerY = player.getLocation().getBlockY();
        return Math.abs(playerY - (blockY = block.getY())) <= 1;
    }
}

