/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.mining;

import java.time.Instant;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class BedMiner
extends Talent {
    private static String name = "BedMiner";
    private static String description = "WARNING::UNSTABLE Bed explosions are bigger and you do not take damage from them.";
    private static String tree = "Mining";
    private static int requiredLevel = 44;
    private static Material icon = Material.RED_BED;
    private static int slot = 44;

    public BedMiner() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new BedMiner(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onBedEnter(PlayerBedEnterEvent e) {
        Player p = e.getPlayer();
        if ((p.getWorld().getEnvironment() == World.Environment.NETHER || p.getWorld().getEnvironment() == World.Environment.THE_END) && BedMiner.hasAbility(p)) {
            e.getPlayer().getWorld().createExplosion(e.getBed().getLocation(), 10.0f, false, true);
            e.setCancelled(true);
            AbilityManager.putCooldown(p, name, 1000);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void entityDamageEvent(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (e.getCause().equals((Object)EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) && BedMiner.hasAbility(p) && AbilityManager.getCooldown(p, name).isAfter(Instant.now())) {
            e.setCancelled(true);
            e.setDamage(0.0);
        }
    }
}

