/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.melee;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Wrath
extends Talent {
    private static String name = "Wrath";
    private static String description = "Killing things with critical hits grants strength II and resistance II for a time equal to the target's max HP in seconds.";
    private static String tree = "Melee";
    private static int requiredLevel = 17;
    private static Material icon = Material.SWEET_BERRIES;
    private static int slot = 17;

    public Wrath() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, "Wrath");
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Wrath(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        Entity entity2 = e.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)entity2;
        if (e.isCancelled()) {
            return;
        }
        if (e.isCritical() && Wrath.hasAbility(p)) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 20 * (int)l.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), 2));
            p.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 20 * (int)l.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), 2));
        }
    }
}

