/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.melee;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Tomahawk
extends Talent {
    private static String name = "Tomahawk";
    private static String description = "Killing things with critical hits grants strength II and resistance II for a time equal to the target's max HP in seconds.";
    private static String tree = "Melee";
    private static int requiredLevel = 27;
    private static Material icon = Material.STONE_AXE;
    private static int slot = 27;

    public Tomahawk() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Tomahawk(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onRightClickAxe(PlayerInteractEvent e) {
        final Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        if (!(e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && Tomahawk.hasAbility(p) && item.getType().name().endsWith("_AXE"))) {
            return;
        }
        final int damage = 10;
        final ArmorStand as = (ArmorStand)p.getWorld().spawnEntity(p.getLocation().add(0.0, 0.7, 0.0), EntityType.ARMOR_STAND);
        as.setInvulnerable(true);
        as.setVisible(false);
        as.setArms(true);
        as.setGravity(false);
        as.setSmall(true);
        as.setMarker(true);
        as.setItem(EquipmentSlot.HAND, item);
        as.setRightArmPose(new EulerAngle(Math.toRadians(90.0), Math.toRadians(0.0), Math.toRadians(0.0)));
        p.getInventory().getItemInMainHand().setAmount(p.getInventory().getItemInMainHand().getAmount() - 1);
        p.playSound(p.getLocation(), Sound.ITEM_TRIDENT_THROW, 1.0f, 0.5f);
        Location dest = p.getLocation().add(p.getLocation().getDirection().multiply(10));
        final Vector vector = dest.subtract(p.getLocation()).toVector();
        new BukkitRunnable(){
            int distance = 50;
            int i = 0;

            public void run() {
                EulerAngle rot = as.getRightArmPose();
                EulerAngle rotNew = rot.add(20.0, 0.0, 0.0);
                as.setRightArmPose(rotNew);
                as.teleport(as.getLocation().add(vector.normalize()));
                if (as.getTargetBlockExact(1) != null && !as.getTargetBlockExact(1).isPassable() && !as.isDead()) {
                    p.playSound(as.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                    if (p.getInventory().firstEmpty() != -1) {
                        p.getInventory().addItem(new ItemStack[]{as.getItem(EquipmentSlot.HAND)});
                    } else {
                        p.getWorld().dropItemNaturally(p.getLocation(), as.getItem(EquipmentSlot.HAND));
                    }
                    as.remove();
                    this.cancel();
                }
                for (Entity entity : as.getLocation().getChunk().getEntities()) {
                    if (as.isDead() || !(as.getLocation().distanceSquared(entity.getLocation()) <= 1.0) || entity == p || entity == as || !(entity instanceof LivingEntity)) continue;
                    p.playSound(entity.getLocation(), Sound.ITEM_TRIDENT_HIT, 1.0f, 1.0f);
                    LivingEntity livingentity = (LivingEntity)entity;
                    livingentity.damage((double)damage, (Entity)p);
                    if (p.getInventory().firstEmpty() != -1) {
                        p.getInventory().addItem(new ItemStack[]{as.getItem(EquipmentSlot.HAND)});
                    } else {
                        p.getWorld().dropItemNaturally(p.getLocation(), as.getItem(EquipmentSlot.HAND));
                    }
                    as.remove();
                    this.cancel();
                }
                if (this.i > this.distance && !as.isDead()) {
                    if (p.getInventory().firstEmpty() != -1) {
                        p.getInventory().addItem(new ItemStack[]{as.getItem(EquipmentSlot.HAND)});
                    } else {
                        p.getWorld().dropItemNaturally(p.getLocation(), as.getItem(EquipmentSlot.HAND));
                    }
                    as.remove();
                    this.cancel();
                }
                ++this.i;
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 2L, 1L);
        e.setCancelled(true);
    }
}

