/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.melee;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.effects.Bleed;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class SpellBlade
extends Talent {
    private static String name = "SpellBlade";
    private static String description = "Melee enchantments provide additional effects.";
    private static String tree = "Melee";
    private static int requiredLevel = 42;
    private static Material icon = Material.LECTERN;
    private static int slot = 42;
    public static Set<EntityType> spiders = EnumSet.of(EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.BEE, EntityType.SILVERFISH, EntityType.ENDERMITE);
    public static Set<EntityType> undead = EnumSet.of(EntityType.ZOMBIE, new EntityType[]{EntityType.DROWNED, EntityType.HUSK, EntityType.ZOMBIE_VILLAGER, EntityType.SKELETON, EntityType.STRAY, EntityType.WITHER_SKELETON, EntityType.WITHER, EntityType.ZOMBIFIED_PIGLIN, EntityType.ZOGLIN, EntityType.PHANTOM, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE});

    public SpellBlade() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new SpellBlade(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        Entity entity2 = e.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)entity2;
        if (e.isCancelled()) {
            return;
        }
        if (!SpellBlade.hasAbility(p)) {
            return;
        }
        Map enchants = p.getInventory().getItemInMainHand().getEnchantments();
        if (enchants.isEmpty()) {
            return;
        }
        if (enchants.containsKey(Enchantment.DAMAGE_ARTHROPODS)) {
            this.spiderAttack(l, (Integer)enchants.get(Enchantment.DAMAGE_ARTHROPODS));
        }
        if (enchants.containsKey(Enchantment.FIRE_ASPECT)) {
            this.fireAttack(p, l, (Integer)enchants.get(Enchantment.FIRE_ASPECT));
        }
        if (enchants.containsKey(Enchantment.DAMAGE_ALL)) {
            this.sharpnessAttack(l, (Integer)enchants.get(Enchantment.DAMAGE_ALL));
        }
        if (enchants.containsKey(Enchantment.DAMAGE_UNDEAD)) {
            this.smiteAttack(l, (Integer)enchants.get(Enchantment.DAMAGE_UNDEAD));
        }
        if (enchants.containsKey(Enchantment.KNOCKBACK)) {
            this.knockbackAttack(l, (Integer)enchants.get(Enchantment.KNOCKBACK));
        }
        if (enchants.containsKey(Enchantment.SWEEPING_EDGE)) {
            this.sweepingAttack(l, (Integer)enchants.get(Enchantment.SWEEPING_EDGE));
        }
        if (enchants.containsKey(Enchantment.LOOT_BONUS_MOBS)) {
            this.lootAttack(p, l, (Integer)enchants.get(Enchantment.LOOT_BONUS_MOBS));
        }
        if (enchants.containsKey(Enchantment.IMPALING)) {
            this.impaleAttack(l, (Integer)enchants.get(Enchantment.IMPALING));
        }
    }

    public void spiderAttack(LivingEntity l, int strength) {
        if (!spiders.contains(l.getType())) {
            return;
        }
        Random rand = new Random();
        int randomInt = rand.nextInt(5) + 1;
        DebugUtility.consoleMessage(name + " Arthropods Roll: " + randomInt + " Needs to be below: " + strength);
        if (randomInt <= strength) {
            l.getWorld().spawnEntity(l.getLocation(), EntityType.CAT);
            l.getWorld().playSound(l.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 0.6f, 0.8f);
            l.setHealth(0.0);
        }
    }

    public void sharpnessAttack(LivingEntity l, int strength) {
        Bleed.bleedEntity(l, strength);
        l.getWorld().playSound(l.getLocation(), Sound.ITEM_TRIDENT_THROW, 0.6f, 1.3f);
    }

    public void fireAttack(final Player p, final LivingEntity l, final int strength) {
        SpellBlade.fireEffect(l, strength);
        l.setFireTicks(l.getFireTicks() + 80 * strength);
        new BukkitRunnable(){

            public void run() {
                DebugUtility.consoleMessage(name + " Fire");
                for (Entity entity : l.getNearbyEntities((double)(1 + strength), (double)(1 + strength), (double)(1 + strength))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity l_nearby = (LivingEntity)entity;
                    if (entity.equals(p)) continue;
                    if (entity.getFireTicks() >= 0) {
                        entity.setFireTicks(entity.getFireTicks() + 80 * strength);
                        continue;
                    }
                    if (l.isInWaterOrRain()) continue;
                    SpellBlade.this.fireAttack(p, l_nearby, strength);
                }
                this.cancel();
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 20L, 1L);
    }

    public void smiteAttack(final LivingEntity l, final int strength) {
        if (!undead.contains(l.getType())) {
            return;
        }
        SpellBlade.smiteEffect(l);
        final int[] count = new int[]{0};
        new BukkitRunnable(){

            public void run() {
                DebugUtility.consoleMessage(name + " Smite");
                if (l.isDead()) {
                    SpellBlade.smiteHealEffect(l, strength);
                    this.cancel();
                } else {
                    SpellBlade.smiteEffect(l);
                }
                count[0] = count[0] + 1;
                if (count[0] >= 40) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 20L, 5L);
    }

    public void knockbackAttack(LivingEntity l, int strength) {
    }

    public void sweepingAttack(LivingEntity l, int strength) {
    }

    public void lootAttack(Player player, LivingEntity l, int strength) {
        if (!(l instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)l;
    }

    @EventHandler
    public void lootKill(EntityDeathEvent event) {
        final Player player = event.getEntity().getKiller();
        if (player == null || !SpellBlade.hasAbility(player)) {
            return;
        }
        Map enchants = player.getInventory().getItemInMainHand().getEnchantments();
        if (!enchants.containsKey(Enchantment.LOOT_BONUS_MOBS)) {
            return;
        }
        ArrayList drops = new ArrayList(event.getDrops());
        if (drops.isEmpty()) {
            return;
        }
        final int[] count = new int[]{0};
        for (ItemStack item : drops) {
            if (!this.hasRoomForItem(player, item)) continue;
            player.getInventory().addItem(new ItemStack[]{item});
            event.getDrops().remove(item);
            count[0] = count[0] + item.getAmount();
            DebugUtility.consoleMessage(name + " Looting " + item.getType() + " x" + item.getAmount());
        }
        new BukkitRunnable(){

            public void run() {
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
                count[0] = count[0] - 1;
                if (count[0] <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 1L);
    }

    public void impaleAttack(LivingEntity l, int strength) {
    }

    public static void fireEffect(final LivingEntity l, final int strength) {
        l.getWorld().playSound(l.getLocation(), Sound.ENTITY_BLAZE_SHOOT, 0.6f, 1.2f);
        final int[] count = new int[]{0};
        new BukkitRunnable(){

            public void run() {
                if (count[0] >= 5 * strength) {
                    this.cancel();
                } else {
                    double radius = 0.2 * (double)count[0];
                    int density = 5;
                    Location loc = l.getEyeLocation().add(0.0, -0.5, 0.0);
                    for (double i = 0.0; i < 360.0; i += (double)density) {
                        double angle = i * Math.PI / 180.0;
                        double x = radius * Math.cos(angle);
                        double z = radius * Math.sin(angle);
                        loc.add(x, 0.0, z);
                        l.getWorld().spawnParticle(Particle.FLAME, loc.getX() + x, loc.getY(), loc.getZ() + z, 1, 0.0, 0.0, 0.0, 0.0);
                        loc.subtract(x, 0.0, z);
                    }
                    count[0] = count[0] + 1;
                }
                DebugUtility.consoleMessage(name + " Fire");
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 1L);
    }

    public static void smiteEffect(LivingEntity l) {
        l.getWorld().spawnParticle(Particle.VILLAGER_ANGRY, l.getEyeLocation(), 1, 0.5, 0.5, 0.5, 0.1);
    }

    public static void smiteHealEffect(LivingEntity l, int strength) {
        for (Entity entity : l.getNearbyEntities(5.0, 5.0, 5.0)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (entity.equals(l)) continue;
            target.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 1, strength));
            target.getWorld().playSound(l.getLocation(), Sound.BLOCK_BELL_RESONATE, 0.5f, 2.5f);
            target.getWorld().spawnParticle(Particle.HEART, target.getEyeLocation(), strength, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public boolean hasRoomForItem(Player player, ItemStack item) {
        PlayerInventory inventory = player.getInventory();
        int remainingSpace = 0;
        for (ItemStack contents : inventory.getStorageContents()) {
            if (contents == null) {
                remainingSpace += item.getMaxStackSize();
                DebugUtility.consoleMessage("Empty slot");
            } else if (contents.isSimilar(item)) {
                remainingSpace += item.getMaxStackSize() - contents.getAmount();
                DebugUtility.consoleMessage("Similar stack " + contents.getAmount() + "/" + contents.getMaxStackSize());
            }
            if (remainingSpace < item.getAmount()) continue;
            DebugUtility.consoleMessage("There is enough space for " + item.getType() + " x" + item.getAmount());
            return true;
        }
        DebugUtility.consoleMessage("There is NOT enough space for " + item.getType() + " x" + item.getAmount());
        return false;
    }
}

