/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.melee;

import java.time.Instant;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.effects.Stun;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Parry
extends Talent {
    private static String name = "Parry";
    private static String description = "Right click with a sword to dodge incoming attacks for 0.5 seconds; 5 second cooldown and slows you with weakness on failed parry; attacking something after a successful parry against it reflects the damage (as bonus damage) and greater knockback, and resets parry cooldown.";
    private static String tree = "Melee";
    private static int requiredLevel = 22;
    private static Material icon = Material.IRON_SWORD;
    private static int slot = 22;

    public Parry() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Parry(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onRightClickWeapon(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || !Parry.hasAbility(p) || !item.getType().name().endsWith("_SWORD")) {
            return;
        }
        p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, 0.5f);
        PersistentDataUtility.store(p, "parry-start", Instant.now().toString());
    }

    @EventHandler
    public void onPlayerTakeDamage(EntityDamageByEntityEvent e) {
        LivingEntity target;
        Player p;
        Entity entity = e.getEntity();
        if (!(entity instanceof Player) || !Parry.hasAbility(p = (Player)entity)) {
            return;
        }
        Entity entity2 = e.getDamager();
        if (entity2 instanceof LivingEntity) {
            LivingEntity l;
            target = l = (LivingEntity)entity2;
        } else {
            Projectile proj;
            entity2 = e.getDamager();
            if (entity2 instanceof Projectile && (entity2 = (proj = (Projectile)entity2).getShooter()) instanceof LivingEntity) {
                LivingEntity l;
                target = l = (LivingEntity)entity2;
            } else {
                return;
            }
        }
        Instant parry_start = Instant.parse(PersistentDataUtility.readString(p, "parry-start"));
        if (!parry_start.plusMillis(1000L).isAfter(Instant.now())) {
            return;
        }
        Stun.stunEntity(target, 50);
        String target_id = "" + target.getEntityId();
        PersistentDataUtility.store(p, "parry-target", target_id);
        p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 0.25f);
        e.setCancelled(true);
    }
}

