/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.melee;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Execute
extends Talent {
    private static String name = "Execute";
    private static String description = "Jump critting a creature makes you ride them and strike them repeatedly.";
    private static String tree = "Melee";
    private static int requiredLevel = 37;
    private static Material icon = Material.SADDLE;
    private static int slot = 37;

    public Execute() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Execute(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        final Player p = (Player)entity;
        Entity entity2 = e.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        final LivingEntity l = (LivingEntity)entity2;
        if (e.isCancelled()) {
            return;
        }
        if ((e.isCritical() || l.getType().equals((Object)EntityType.ENDER_DRAGON) || l.getType().equals((Object)EntityType.WITHER)) && Execute.hasAbility(p)) {
            this.rideEntity(p, (Entity)l);
            new BukkitRunnable(){

                public void run() {
                    if (l.isDead() || l.getPassengers().isEmpty()) {
                        this.cancel();
                    } else {
                        double amount = p.getInventory().getItemInMainHand().hasItemMeta() && p.getInventory().getItemInMainHand().getItemMeta() != null ? Execute.this.calculateItemAttackDamage(p, l, p.getInventory().getItemInMainHand()) : 1.0;
                        l.damage(amount, (Entity)p);
                        Execute.this.damageItem(p, l);
                        p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 1.0f);
                    }
                    DebugUtility.consoleMessage(name);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 20L);
        }
    }

    public void rideEntity(Player player, Entity entity) {
        Entity passenger;
        Entity entity2 = passenger = player.getPassengers().isEmpty() ? null : (Entity)player.getPassengers().get(0);
        if (passenger != null) {
            passenger.eject();
        }
        entity.addPassenger((Entity)player);
    }

    public void damageItem(Player player, LivingEntity entity) {
        ItemStack item = player.getInventory().getItemInMainHand();
        item.damage(1, entity);
    }

    double calculateItemAttackDamage(Player player, LivingEntity victim, ItemStack item) {
        if (item != null && item.getItemMeta().hasEnchants()) {
            int fireaspectLVL;
            int sharpnessLVL;
            double attackDamage = 0.0;
            attackDamage = item.getType().equals((Object)Material.NETHERITE_SWORD) ? 8.0 : (item.getType().equals((Object)Material.DIAMOND_SWORD) ? 7.0 : (item.getType().equals((Object)Material.IRON_SWORD) ? 6.0 : (item.getType().equals((Object)Material.STONE_SWORD) ? 5.0 : (item.getType().equals((Object)Material.GOLDEN_SWORD) ? 4.0 : (item.getType().equals((Object)Material.WOODEN_SWORD) ? 4.0 : (item.getType().equals((Object)Material.NETHERITE_AXE) ? 10.0 : (item.getType().equals((Object)Material.DIAMOND_AXE) ? 9.0 : (item.getType().equals((Object)Material.IRON_AXE) ? 9.0 : (item.getType().equals((Object)Material.STONE_AXE) ? 9.0 : (item.getType().equals((Object)Material.GOLDEN_AXE) ? 7.0 : (item.getType().equals((Object)Material.WOODEN_AXE) ? 7.0 : (item.getType().equals((Object)Material.NETHERITE_PICKAXE) ? 6.0 : (item.getType().equals((Object)Material.DIAMOND_PICKAXE) ? 5.0 : (item.getType().equals((Object)Material.IRON_PICKAXE) ? 4.0 : (item.getType().equals((Object)Material.STONE_PICKAXE) ? 3.0 : (item.getType().equals((Object)Material.GOLDEN_PICKAXE) ? 2.0 : (item.getType().equals((Object)Material.WOODEN_PICKAXE) ? 2.0 : (item.getType().equals((Object)Material.NETHERITE_SHOVEL) ? 6.5 : (item.getType().equals((Object)Material.DIAMOND_SHOVEL) ? 5.5 : (item.getType().equals((Object)Material.IRON_SHOVEL) ? 4.5 : (item.getType().equals((Object)Material.STONE_SHOVEL) ? 3.5 : (item.getType().equals((Object)Material.GOLDEN_SHOVEL) ? 2.5 : (item.getType().equals((Object)Material.WOODEN_SHOVEL) ? 2.5 : (item.getType().equals((Object)Material.NETHERITE_HOE) ? 1.0 : (item.getType().equals((Object)Material.DIAMOND_HOE) ? 1.0 : (item.getType().equals((Object)Material.IRON_HOE) ? 1.0 : (item.getType().equals((Object)Material.STONE_HOE) ? 1.0 : (item.getType().equals((Object)Material.GOLDEN_HOE) ? 1.0 : (item.getType().equals((Object)Material.WOODEN_HOE) ? 1.0 : (item.getType().equals((Object)Material.TRIDENT) ? 9.0 : 1.0))))))))))))))))))))))))))))));
            if (player.hasPotionEffect(PotionEffectType.INCREASE_DAMAGE)) {
                int strenghteffectLVL = player.getPotionEffect(PotionEffectType.INCREASE_DAMAGE).getAmplifier();
                attackDamage += (double)(3 * strenghteffectLVL);
            }
            if ((sharpnessLVL = item.getEnchantmentLevel(Enchantment.DAMAGE_ALL)) > 0) {
                if (sharpnessLVL == 1) {
                    attackDamage += 1.0;
                } else if (sharpnessLVL == 2) {
                    attackDamage += 1.5;
                } else if (sharpnessLVL == 3) {
                    attackDamage += 2.0;
                } else if (sharpnessLVL == 4) {
                    attackDamage += 2.5;
                } else if (sharpnessLVL == 5) {
                    attackDamage += 3.0;
                }
            }
            if ((fireaspectLVL = item.getEnchantmentLevel(Enchantment.FIRE_ASPECT)) > 0) {
                attackDamage += (double)(fireaspectLVL * 4 - 1);
            }
            return attackDamage;
        }
        double attackDamage = 0.0;
        attackDamage = item.getType().equals((Object)Material.NETHERITE_SWORD) ? 8.0 : (item.getType().equals((Object)Material.DIAMOND_SWORD) ? 7.0 : (item.getType().equals((Object)Material.IRON_SWORD) ? 6.0 : (item.getType().equals((Object)Material.STONE_SWORD) ? 5.0 : (item.getType().equals((Object)Material.GOLDEN_SWORD) ? 4.0 : (item.getType().equals((Object)Material.WOODEN_SWORD) ? 4.0 : (item.getType().equals((Object)Material.NETHERITE_AXE) ? 10.0 : (item.getType().equals((Object)Material.DIAMOND_AXE) ? 9.0 : (item.getType().equals((Object)Material.IRON_AXE) ? 9.0 : (item.getType().equals((Object)Material.STONE_AXE) ? 9.0 : (item.getType().equals((Object)Material.GOLDEN_AXE) ? 7.0 : (item.getType().equals((Object)Material.WOODEN_AXE) ? 7.0 : (item.getType().equals((Object)Material.NETHERITE_PICKAXE) ? 6.0 : (item.getType().equals((Object)Material.DIAMOND_PICKAXE) ? 5.0 : (item.getType().equals((Object)Material.IRON_PICKAXE) ? 4.0 : (item.getType().equals((Object)Material.STONE_PICKAXE) ? 3.0 : (item.getType().equals((Object)Material.GOLDEN_PICKAXE) ? 2.0 : (item.getType().equals((Object)Material.WOODEN_PICKAXE) ? 2.0 : (item.getType().equals((Object)Material.NETHERITE_SHOVEL) ? 6.5 : (item.getType().equals((Object)Material.DIAMOND_SHOVEL) ? 5.5 : (item.getType().equals((Object)Material.IRON_SHOVEL) ? 4.5 : (item.getType().equals((Object)Material.STONE_SHOVEL) ? 3.5 : (item.getType().equals((Object)Material.GOLDEN_SHOVEL) ? 2.5 : (item.getType().equals((Object)Material.WOODEN_SHOVEL) ? 2.5 : (item.getType().equals((Object)Material.NETHERITE_HOE) ? 1.0 : (item.getType().equals((Object)Material.DIAMOND_HOE) ? 1.0 : (item.getType().equals((Object)Material.IRON_HOE) ? 1.0 : (item.getType().equals((Object)Material.STONE_HOE) ? 1.0 : (item.getType().equals((Object)Material.GOLDEN_HOE) ? 1.0 : (item.getType().equals((Object)Material.WOODEN_HOE) ? 1.0 : (item.getType().equals((Object)Material.TRIDENT) ? 9.0 : 1.0))))))))))))))))))))))))))))));
        if (player.hasPotionEffect(PotionEffectType.INCREASE_DAMAGE)) {
            int strenghteffectLVL = player.getPotionEffect(PotionEffectType.INCREASE_DAMAGE).getAmplifier();
            attackDamage += (double)(3 * strenghteffectLVL);
        }
        return attackDamage;
    }

    @EventHandler
    public void onPlayerHitByMount(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        Entity entity2 = e.getDamager();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)entity2;
        if (!Execute.hasAbility(p)) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (l.getPassengers().contains(p)) {
            e.setCancelled(true);
        }
    }
}

