/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.melee;

import java.time.Instant;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Brawler
extends Talent {
    private static String name = "Brawler";
    private static String description = "Deal more damage with your fists. +2.0 damage per stack, up to 5 times. Gain a stack with every punch and lose stacks without attacking for 5 seconds.";
    private static String tree = "Melee";
    private static int requiredLevel = 5;
    private static Material icon = Material.BRICK;
    private static int slot = 5;

    public Brawler() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Brawler(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        Entity entity2 = e.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)entity2;
        if (e.isCancelled()) {
            return;
        }
        if (!Brawler.hasAbility(p)) {
            return;
        }
        if (p.getInventory().getItemInMainHand().getType().equals((Object)Material.AIR)) {
            NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "brawler-stacks");
            if (!p.getPersistentDataContainer().has(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "brawler-stacks"), PersistentDataType.INTEGER)) {
                p.getPersistentDataContainer().set(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "brawler-stacks"), PersistentDataType.INTEGER, (Object)0);
            }
            if (AbilityManager.getCooldown(p, "Brawler").isBefore(Instant.now().minusMillis(5000L))) {
                p.getPersistentDataContainer().set(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "brawler-stacks"), PersistentDataType.INTEGER, (Object)0);
            }
            if ((Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER) < 5) {
                p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)((Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER) + 1));
            }
            int stacks = (Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
            e.setDamage(e.getDamage() + 2.0 * (double)stacks);
            AbilityManager.putCooldown(p, "Brawler", 5000);
            p.playSound(e.getEntity().getLocation(), Sound.BLOCK_COMPOSTER_FILL_SUCCESS, (float)stacks * 5.0f, 4.0f);
            for (int i = 0; i < 20 * stacks; ++i) {
                p.spawnParticle(Particle.CRIT, e.getEntity().getLocation(), 1, Math.random(), Math.random(), Math.random());
            }
        }
    }
}

