/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.melee;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.skillgroups.Melee;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Bloody
extends Talent {
    private static String name = "Bloody";
    private static String description = "Critical strikes with a sword apply a bleed equal to 50% of initial damage over 5 seconds.";
    private static String tree = "Melee";
    private static int requiredLevel = 10;
    private static Material icon = Material.NETHER_WART;
    private static int slot = 10;

    public Bloody() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, "Bloody");
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Bloody(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        Entity entity2 = e.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)entity2;
        if (e.isCancelled()) {
            return;
        }
        if (!Bloody.hasAbility(p)) {
            return;
        }
        double original_damage = e.getFinalDamage();
        if (!Melee.swords.contains(p.getInventory().getItemInMainHand().getType()) || original_damage > 1.0) {
            // empty if block
        }
    }
}

