/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class WebCrawler
extends Talent {
    private static String name = "WebCrawler";
    private static String description = "Left Click: Place a web, which can slow mobs.    Right Click: Pull yourself towards a web, destroying it; crouch at any point to release.";
    private static String tree = "Magic";
    private static int requiredLevel = 27;
    private static Material icon = Material.COBWEB;
    private static int slot = 27;
    private static float mana_cost = 0.5f;

    public WebCrawler() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new WebCrawler(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        AbilityManager.putCooldown(e.getPlayer(), name, 50);
        if (isSecondary) {
            WebCrawler.secondary(e);
        } else {
            WebCrawler.primary(e);
        }
    }

    public static void secondary(PlayerInteractEvent e) {
        final Player p = e.getPlayer();
        RayTraceResult result = p.rayTraceBlocks(200.0);
        if (result == null || result.getHitBlock() == null) {
            return;
        }
        final Block target_block = result.getHitBlock();
        if (!target_block.getType().equals((Object)Material.COBWEB)) {
            return;
        }
        if (!Mana.manaConsume(p, 1.0f, name)) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        if (!WebCrawler.breakWeb(target_block)) {
            return;
        }
        p.setVelocity(new Vector(0, 0, 0));
        new BukkitRunnable(){

            /*
             * Enabled aggressive block sorting
             */
            public void run() {
                if (p.isSneaking()) {
                    this.cancel();
                    p.setGravity(true);
                    p.setFallDistance(0.0f);
                } else if (p.getLocation().distance(target_block.getLocation()) >= 2.0) {
                    double distance = target_block.getLocation().distance(p.getLocation());
                    WebCrawler.updatePlayerVelocity(p, target_block.getLocation());
                    p.setFallDistance(0.0f);
                    WebCrawler.drawline(p.getLocation(), target_block.getLocation(), 2.0);
                    p.playSound(target_block.getLocation(), Sound.BLOCK_TRIPWIRE_ATTACH, 0.4f, 1.5f);
                    if (!(p.getLocation().distance(target_block.getLocation()) <= 3.0)) {
                        // empty if block
                    }
                } else {
                    p.setVelocity(new Vector(0, 0, 0));
                }
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 1L, 1L);
    }

    public static void primary(PlayerInteractEvent e) {
        Block web_spot;
        Player p = e.getPlayer();
        Entity target_entity = p.getTargetEntity(120);
        if (target_entity != null) {
            web_spot = target_entity.getLocation().getBlock();
        } else {
            RayTraceResult result = p.rayTraceBlocks(200.0);
            if (result == null || result.getHitBlock() == null) {
                return;
            }
            Block target_block = result.getHitBlock();
            BlockFace face = result.getHitBlockFace();
            assert (face != null);
            web_spot = target_block.getRelative(face);
        }
        if (web_spot.getType().equals((Object)Material.AIR)) {
            if (!Mana.manaConsume(p, mana_cost, name)) {
                p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
                return;
            }
            if (!WebCrawler.placeWeb(web_spot)) {
                p.playSound(p.getLocation(), Sound.BLOCK_CAMPFIRE_CRACKLE, 1.0f, 1.0f);
                return;
            }
            p.playSound(p.getLocation(), Sound.BLOCK_SHROOMLIGHT_PLACE, 1.0f, 1.0f);
        } else {
            p.playSound(p.getLocation(), Sound.BLOCK_CAMPFIRE_CRACKLE, 1.0f, 1.0f);
        }
    }

    public static boolean placeWeb(Block web_spot) {
        web_spot.setType(Material.COBWEB);
        return true;
    }

    public static boolean breakWeb(Block web_spot) {
        if (web_spot.getType().equals((Object)Material.COBWEB)) {
            web_spot.setType(Material.AIR);
            return true;
        }
        return false;
    }

    private static void updatePlayerVelocity(Player p, Location target) {
        double radius = p.getEyeLocation().distance(target);
        double x_diff = Math.abs(p.getLocation().getX() - target.getX());
        double z_diff = Math.abs(p.getLocation().getZ() - target.getZ());
        double lateral_radius = Math.sqrt(x_diff * x_diff + z_diff * z_diff);
        Vector difference = target.toVector().subtract(p.getEyeLocation().toVector());
        p.setVelocity(difference.normalize().multiply(1.2));
    }

    private static void drawline(Location point1, Location point2, double space) {
        World world = point1.getWorld();
        double distance = point1.distance(point2);
        Vector p1 = point1.toVector();
        Vector p2 = point2.toVector();
        Vector vector = p2.clone().subtract(p1).normalize().multiply(space);
        for (double covered = 0.0; covered < distance; covered += space) {
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.WHITE, 1.0f);
            world.spawnParticle(Particle.REDSTONE, p1.getX(), p1.getY(), p1.getZ(), 1, (Object)dustOptions);
            p1.add(vector);
        }
    }
}

