/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Conjure;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class TimeIsMana
extends Talent {
    private static String name = "TimeIsMana";
    private static String description = "All abilities cost no mana, but have cooldowns proportional to their original mana costs.";
    private static String tree = "Magic";
    private static int requiredLevel = 30;
    private static Material icon = Material.CLOCK;
    private static int slot = 30;

    public TimeIsMana() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new TimeIsMana(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void manaToCooldown(Player p, String spell, float mana) {
        if (mana < 0.0f) {
            return;
        }
        int ms = (int)((double)(mana * 10000.0f) * Math.pow(1.1, TimeIsMana.getLoanMana(p) + 1));
        AbilityManager.putCooldown(p, spell, ms);
    }

    public static int getLoanMana(Player p) {
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "loan_mana");
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.INTEGER) || !AbilityManager.hasAbility(p, Conjure.getName())) {
            p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
        }
        int loan_mana = (Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
        return loan_mana;
    }
}

