/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Spy
extends Talent {
    private static String name = "Spy";
    private static String description = "Turn invisible at the cost of mana over time; exit invisibility if performing any action (higher levels are enough to sustain this indefinitely)";
    private static String tree = "Magic";
    private static int requiredLevel = 12;
    private static Material icon = Material.GLASS;
    private static int slot = 12;
    private static float mana_cost_per_second = 0.05f;
    private static float mana_cost_per_tick = mana_cost_per_second / 20.0f;

    public Spy() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Spy(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    private static boolean manaConsume(Player p, float mana_cost) {
        return Mana.manaConsume(p, mana_cost, name);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        if (isSecondary) {
            Spy.secondary(e);
        } else {
            Spy.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            p.removePotionEffect(PotionEffectType.INVISIBILITY);
            p.playSound(p.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
        } else {
            p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0));
            p.playSound(p.getLocation(), Sound.ENTITY_EVOKER_CAST_SPELL, 1.0f, 1.0f);
            Spy.manaDrain(p, mana_cost_per_tick);
        }
    }

    public static void secondary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Entity target = p.getTargetEntity(100);
        if (target instanceof LivingEntity) {
            if (Spy.manaConsume(p, 5.0f)) {
                ((LivingEntity)target).addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 600, 0));
                p.playSound(target.getLocation(), Sound.ENTITY_EVOKER_CAST_SPELL, 1.0f, 1.0f);
            } else {
                p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            }
        }
    }

    public static void manaDrain(final Player p, final float amount) {
        new BukkitRunnable(){

            public void run() {
                if (Spy.hasAbility(p) && p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                    float cost = amount * 4.0f;
                    if (p.isSprinting() || p.isFlying() || p.isJumping() || p.isSwimming()) {
                        cost *= 4.0f;
                    } else if (p.isSneaking() || p.isSleeping()) {
                        cost /= 4.0f;
                    }
                    if (!Mana.manaConsume(p, cost, name)) {
                        p.removePotionEffect(PotionEffectType.INVISIBILITY);
                        p.playSound(p.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
                        this.cancel();
                    }
                } else {
                    this.cancel();
                }
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 4L);
    }
}

