/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.effects.Charm;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;

public class Necromancy
extends Talent {
    private static String name = "Necromancy";
    private static String description = "Right Click: Apply a death mark which withers and weakens the target; if the target dies, you absorb their life force, healing for half their max health. Overflows into temporary extra health.   Left Click: Expend souls to spawn undead mobs to fight for you.";
    private static String tree = "Magic";
    private static int requiredLevel = 42;
    private static Material icon = Material.WITHER_ROSE;
    private static int slot = 42;
    private static float mana_cost = 0.5f;
    public static HashMap<EntityType, Integer> undeadEntities = new HashMap();
    public static HashMap<EntityType, Integer> overWorldUndead = new HashMap();
    public static HashMap<EntityType, Integer> netherUndead = new HashMap();
    public static HashMap<EntityType, Integer> endUndead = new HashMap();

    public Necromancy() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Necromancy(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Necromancy.populateUndeadEntities();
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        AbilityManager.putCooldown(e.getPlayer(), name, 50);
        if (isSecondary) {
            Necromancy.secondary(e);
        } else {
            Necromancy.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (PersistentDataUtility.readInt((Entity)p, "souls", 0) <= 1) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            p.sendMessage("You have no souls to use.");
            return;
        }
        RayTraceResult result = p.rayTraceBlocks(20.0);
        if (result == null || result.getHitBlock() == null) {
            return;
        }
        Block target_block = result.getHitBlock();
        BlockFace face = result.getHitBlockFace();
        assert (face != null);
        Location spawn_spot = target_block.getRelative(face).getLocation();
        int souls = PersistentDataUtility.readInt((Entity)p, "souls", 0);
        if (p.getWorld().getEnvironment() == World.Environment.NORMAL) {
            Necromancy.summonMob(spawn_spot, Necromancy.rollMob(overWorldUndead, souls), p, souls);
        } else if (p.getWorld().getEnvironment() == World.Environment.NETHER) {
            Necromancy.summonMob(spawn_spot, Necromancy.rollMob(netherUndead, souls), p, souls);
        } else if (p.getWorld().getEnvironment() == World.Environment.THE_END) {
            Necromancy.summonMob(spawn_spot, Necromancy.rollMob(endUndead, souls), p, souls);
        } else {
            Necromancy.summonMob(spawn_spot, Necromancy.rollMob(undeadEntities, souls), p, souls);
        }
    }

    public static void secondary(PlayerInteractEvent e) {
        LivingEntity target_entity;
        final Player p = e.getPlayer();
        Entity entity = p.getTargetEntity(40);
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity && !(target_entity = (LivingEntity)entity).hasPotionEffect(PotionEffectType.WITHER)) {
            if (!Mana.manaConsume(p, 0.1f * (float)target_entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), name)) {
                p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
                return;
            }
            p.playSound(p.getLocation(), Sound.ENTITY_HUSK_CONVERTED_TO_ZOMBIE, 1.0f, 0.8f);
            target_entity.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 1200, 1));
            target_entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 1200, 0));
            if (!Charm.checkCharm(target_entity)) {
                PersistentDataUtility.store(p, "charm-target", target_entity.getUniqueId().toString());
            }
            new BukkitRunnable(){

                public void run() {
                    if (target_entity.isDead()) {
                        int count = (int)Math.round(target_entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 4.0);
                        Necromancy.soulAbsorbEffects(target_entity, p, Particle.SOUL, count);
                        this.cancel();
                    } else if (!target_entity.hasPotionEffect(PotionEffectType.WITHER)) {
                        this.cancel();
                    } else {
                        target_entity.getWorld().spawnParticle(Particle.SMOKE_NORMAL, target_entity.getEyeLocation(), 10, 0.5, 0.5, 0.5, 0.1);
                    }
                    DebugUtility.consoleMessage(name);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 1L, 4L);
        }
    }

    public static void soulAbsorbEffects(final LivingEntity from, final Player to, final Particle particle, final int count) {
        final Location start = from.getLocation();
        if (from.getDeathSound() == null) {
            return;
        }
        to.playSound(to.getLocation(), from.getDeathSound(), 0.65f, 0.8f);
        new BukkitRunnable(){
            double t = 0.0;

            public void run() {
                this.t += 0.025;
                if (this.t > 1.0) {
                    to.playSound(to.getLocation(), Sound.ENTITY_ZOMBIE_VILLAGER_CONVERTED, 1.0f, 0.8f);
                    if (to.getHealth() >= Objects.requireNonNull(to.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getValue()) {
                        to.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 1, (int)Math.round(from.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 4.0)));
                    } else {
                        to.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 1, (int)Math.round(from.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 4.0)));
                    }
                    int souls = PersistentDataUtility.readInt((Entity)to, "souls", 0);
                    PersistentDataUtility.store((Entity)to, "souls", souls + 1);
                    if ((souls + 1) / 10 != souls / 10) {
                        to.sendMessage("Absorbed " + from.getType() + ". You have " + (souls + 1) + " souls.");
                    }
                    this.cancel();
                    return;
                }
                double x = start.getX() + (to.getLocation().getX() - start.getX()) * this.t;
                double y = start.getY() + (to.getLocation().getY() - start.getY()) * this.t;
                double z = start.getZ() + (to.getLocation().getZ() - start.getZ()) * this.t;
                Location soul_location = to.getWorld().getBlockAt((int)x, (int)y, (int)z).getLocation();
                start.getWorld().spawnParticle(particle, soul_location, count, 0.5, 0.5, 0.5, 0.1);
                to.playSound(soul_location, Sound.ENTITY_VEX_DEATH, 0.6f, 0.8f);
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 1L);
    }

    public static void populateUndeadEntities() {
        undeadEntities.put(EntityType.ZOMBIE, 2);
        undeadEntities.put(EntityType.DROWNED, 2);
        undeadEntities.put(EntityType.HUSK, 2);
        undeadEntities.put(EntityType.ZOMBIE_VILLAGER, 2);
        undeadEntities.put(EntityType.SKELETON, 2);
        undeadEntities.put(EntityType.STRAY, 3);
        undeadEntities.put(EntityType.WITHER_SKELETON, 6);
        undeadEntities.put(EntityType.ZOMBIFIED_PIGLIN, 2);
        undeadEntities.put(EntityType.PHANTOM, 6);
        undeadEntities.put(EntityType.ZOGLIN, 8);
        undeadEntities.put(EntityType.ZOMBIE_HORSE, 4);
        undeadEntities.put(EntityType.SKELETON_HORSE, 4);
        overWorldUndead.put(EntityType.ZOMBIE, 2);
        overWorldUndead.put(EntityType.DROWNED, 2);
        overWorldUndead.put(EntityType.HUSK, 2);
        overWorldUndead.put(EntityType.ZOMBIE_VILLAGER, 2);
        overWorldUndead.put(EntityType.SKELETON, 2);
        overWorldUndead.put(EntityType.STRAY, 3);
        overWorldUndead.put(EntityType.PHANTOM, 6);
        overWorldUndead.put(EntityType.ZOMBIE_HORSE, 4);
        overWorldUndead.put(EntityType.SKELETON_HORSE, 4);
        netherUndead.put(EntityType.SKELETON, 2);
        netherUndead.put(EntityType.SKELETON_HORSE, 4);
        netherUndead.put(EntityType.WITHER_SKELETON, 6);
        netherUndead.put(EntityType.ZOMBIFIED_PIGLIN, 2);
        netherUndead.put(EntityType.ZOGLIN, 8);
        endUndead.put(EntityType.ZOMBIE_VILLAGER, 2);
        endUndead.put(EntityType.ZOMBIE_HORSE, 4);
        endUndead.put(EntityType.PHANTOM, 6);
    }

    public static void summonMob(Location location, EntityType entityType, Player source, int souls) {
        Mob rider;
        Mob summon = (Mob)location.getWorld().spawnEntity(location, entityType);
        PersistentDataUtility.store((Entity)source, "souls", souls - undeadEntities.get(summon.getType()));
        Charm.charmEntity(summon, 12000, (LivingEntity)source);
        if (summon.getType().equals((Object)EntityType.SKELETON_HORSE)) {
            rider = (Mob)location.getWorld().spawnEntity(location, EntityType.SKELETON);
            Charm.charmEntity(rider, 12000, (LivingEntity)source);
            summon.addPassenger((Entity)rider);
        }
        if (summon.getType().equals((Object)EntityType.ZOMBIE_HORSE)) {
            rider = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE_VILLAGER);
            Charm.charmEntity(rider, 12000, (LivingEntity)source);
            summon.addPassenger((Entity)rider);
        }
    }

    public static EntityType rollMob(HashMap<EntityType, Integer> mob_set, int souls) {
        Random random = new Random();
        int randomIndex = random.nextInt(mob_set.size());
        int i = 0;
        for (Map.Entry<EntityType, Integer> entry : mob_set.entrySet()) {
            if (i == randomIndex) {
                if (entry.getValue() > souls) {
                    return Necromancy.rollMob(mob_set, souls);
                }
                return entry.getKey();
            }
            ++i;
        }
        return null;
    }
}

