/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Medic
extends Talent {
    private static String name = "Medic";
    private static String description = "Left Click: heal target player and removes negative debuffs; applies self if no target; overheal to give a health boost (mk2 heal is aoe); applies damage to undead mobs.   Right Click: Drain mana to give regeneration to all entities you have healed since beginning this effect.";
    private static String tree = "Magic";
    private static int requiredLevel = 18;
    private static Material icon = Material.RED_DYE;
    private static int slot = 18;
    private static final float mana_cost_per_second = 0.5f;
    private static final float mana_cost_per_tick = 0.025f;

    public Medic() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Medic(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    private static boolean manaConsume(Player p, float mana_cost) {
        return Mana.manaConsume(p, mana_cost, name);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        if (isSecondary) {
            Medic.secondary(e);
        } else {
            Medic.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Entity entity = p.getTargetEntity(100);
        if (!Mana.manaConsume(p, 3.0f, name)) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        Medic.healPlayer((LivingEntity)p);
        Medic.healEffect((LivingEntity)p);
        if (entity instanceof LivingEntity) {
            LivingEntity target_entity = (LivingEntity)entity;
            Medic.healPlayer(target_entity);
            Medic.healEffect(target_entity);
        }
    }

    public static void secondary(PlayerInteractEvent e) {
        final Player p = e.getPlayer();
        Entity entity = p.getTargetEntity(20);
        if (p.hasPotionEffect(PotionEffectType.REGENERATION)) {
            p.removePotionEffect(PotionEffectType.REGENERATION);
            p.playSound(p.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 0.75f);
        } else {
            if (entity == null) {
                return;
            }
            if (entity instanceof LivingEntity) {
                final LivingEntity target_entity = (LivingEntity)entity;
                if (!Mana.manaConsume(p, 0.1f, name)) {
                    p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
                    return;
                }
                p.playSound(p.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 2.5f);
                target_entity.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, 1));
                p.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, 1));
                Medic.sendParticlesFromEntityToEntity((Entity)p, (Entity)target_entity, Particle.HEART, 10);
                new BukkitRunnable(){

                    public void run() {
                        if (!Mana.hasEnoughMana(p, 0.1f) || !p.hasPotionEffect(PotionEffectType.REGENERATION) || p.getLocation().distance(target_entity.getLocation()) > 20.0) {
                            p.removePotionEffect(PotionEffectType.REGENERATION);
                            target_entity.removePotionEffect(PotionEffectType.REGENERATION);
                            this.cancel();
                        }
                        if (target_entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() > target_entity.getHealth() || p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() > p.getHealth()) {
                            Mana.manaConsume(p, 0.1f, name);
                            Medic.sendParticlesFromEntityToEntity((Entity)p, (Entity)target_entity, Particle.HEART, 10);
                        }
                        target_entity.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, 1));
                        p.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, 1));
                        DebugUtility.consoleMessage(name + " secondary", 4);
                    }
                }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 20L);
            }
        }
    }

    public static void healPlayer(LivingEntity target_entity) {
        target_entity.removePotionEffect(PotionEffectType.SLOW);
        target_entity.removePotionEffect(PotionEffectType.POISON);
        target_entity.removePotionEffect(PotionEffectType.WITHER);
        target_entity.removePotionEffect(PotionEffectType.HUNGER);
        target_entity.removePotionEffect(PotionEffectType.SLOW_DIGGING);
        target_entity.removePotionEffect(PotionEffectType.BLINDNESS);
        target_entity.removePotionEffect(PotionEffectType.CONFUSION);
        target_entity.removePotionEffect(PotionEffectType.WEAKNESS);
        target_entity.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 1, 1));
        target_entity.getWorld().playSound(target_entity.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 2.5f);
        target_entity.getWorld().spawnParticle(Particle.HEART, target_entity.getEyeLocation(), 10, 0.5, 0.5, 0.5, 0.1);
    }

    public static void sendParticlesFromEntityToEntity(Entity from, Entity to, Particle particle, int count) {
        Location fromLoc = from.getLocation();
        Location toLoc = to.getLocation();
        double xDiff = toLoc.getX() - fromLoc.getX();
        double yDiff = toLoc.getY() - fromLoc.getY();
        double zDiff = toLoc.getZ() - fromLoc.getZ();
        for (int i = 0; i < count; ++i) {
            double x = fromLoc.getX() + xDiff * (double)i / (double)count;
            double y = fromLoc.getY() + yDiff * (double)i / (double)count;
            double z = fromLoc.getZ() + zDiff * (double)i / (double)count;
            from.getWorld().spawnParticle(particle, x, y, z, 1);
        }
    }

    public static void healEffect(LivingEntity l) {
        l.getWorld().spawnParticle(Particle.HEART, l.getEyeLocation(), 5, 0.5, 0.5, 0.5, 0.1);
    }
}

