/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Conjure;
import me.ultra42.ultraskills.abilities.magic.TimeIsMana;
import me.ultra42.ultraskills.skillgroups.Magic;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class Mana
extends Talent {
    private static String name = "Mana";
    private static String description = "Regenerate vanilla experience passively up to your your Magic level.";
    private static String tree = "Magic";
    private static int requiredLevel = 8;
    private static Material icon = Material.LAPIS_LAZULI;
    private static int slot = 8;

    public Mana() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Mana(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Mana.scheduler();
    }

    public static void scheduler() {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), () -> {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                if (!Mana.hasAbility(p)) continue;
                int lvl = Magic.getLevel(p, tree);
                if (p.getLevel() - 1 < lvl - Mana.getLoanMana(p) && p.getExp() + 5.0E-4f * (float)lvl < 1.0f) {
                    Mana.giveMana(p, 5.0E-4f * (float)lvl);
                    continue;
                }
                if (p.getLevel() >= lvl - Mana.getLoanMana(p) || !(p.getExp() + 5.0E-4f * (float)lvl > 1.0f)) continue;
                Mana.giveMana(p, 5.0E-4f * (float)lvl);
            }
        }, 0L, 1L);
    }

    public static void giveMana(Player p, float amount) {
        if (amount < 0.0f) {
            return;
        }
        int lvl_amount = (int)Math.floor(amount);
        float xp_amount = amount - (float)lvl_amount;
        p.setLevel(p.getLevel() + lvl_amount);
        float xp = p.getExp();
        xp += xp_amount;
        if (xp > 1.0f) {
            xp = 0.0f;
            p.setLevel(p.getLevel() + 1);
        }
        p.setExp(xp);
    }

    public static boolean manaConsume(Player p, float amount, String spell) {
        float xp;
        if (amount < 0.0f) {
            return false;
        }
        if (AbilityManager.hasAbility(p, "TimeIsMana") && AbilityManager.isOffCooldown(p, spell)) {
            TimeIsMana.manaToCooldown(p, spell, amount);
            return true;
        }
        if (AbilityManager.hasAbility(p, "TimeIsMana")) {
            return false;
        }
        int lvl_amount = (int)Math.floor(amount);
        float xp_amount = amount - (float)lvl_amount;
        if (lvl_amount > p.getLevel() + 1) {
            return false;
        }
        if ((double)lvl_amount >= 1.0) {
            p.setLevel(p.getLevel() - lvl_amount);
        }
        if ((xp = p.getExp() - xp_amount) < 0.0f) {
            if (p.getLevel() > 0) {
                xp += 1.0f;
                p.setLevel(p.getLevel() - 1);
            } else {
                return false;
            }
        }
        p.setExp(xp);
        Magic.giveXP(p, tree, (int)(amount * 100.0f), "SPELL-CASTING");
        return true;
    }

    public static void indicators(Player p) {
        for (int i = 0; i < 20; ++i) {
            p.spawnParticle(Particle.COMPOSTER, p.getEyeLocation(), 1, Math.random(), Math.random(), Math.random());
        }
        UltraSkills.getPlugin().getLogger().info(p.getName() + " gains energy from the sun. (4s)");
    }

    public static int getLoanMana(Player p) {
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "loan_mana");
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.INTEGER) || !AbilityManager.hasAbility(p, Conjure.getName())) {
            p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
        }
        int loan_mana = (Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
        return loan_mana;
    }

    public static boolean hasEnoughMana(Player p, float amount) {
        if (amount < 0.0f) {
            return false;
        }
        int lvl_amount = (int)Math.floor(amount);
        float xp_amount = amount - (float)lvl_amount;
        if (lvl_amount > p.getLevel() + 1) {
            return false;
        }
        float xp = p.getExp() - xp_amount;
        return !(xp < 0.0f) || p.getLevel() > 0;
        {
        }
    }
}

