/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.effects.Stun;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;

public class LightningInABottle
extends Talent {
    private static String name = "LightningInABottle";
    private static String description = "Bring lightning down on your target; 10% casting cost during thunderstorms. When striking yourself, get saturation, resistance, and strength.";
    private static String tree = "Magic";
    private static int requiredLevel = 35;
    private static Material icon = Material.GLASS_BOTTLE;
    private static int slot = 35;
    private static float mana_cost = 5.0f;

    public LightningInABottle() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new LightningInABottle(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        if (isSecondary) {
            LightningInABottle.secondary(e);
        } else {
            LightningInABottle.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Block target_block = p.getTargetBlock(100);
        Entity target_entity = p.getTargetEntity(100);
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "lightning-stacks");
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) {
            p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
        }
        int strikes = (Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
        if (target_entity instanceof LivingEntity) {
            if (Mana.manaConsume(p, mana_cost, name)) {
                LightningInABottle.lightningStrike(p, target_entity, strikes);
                p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
                p.playSound(p.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
            } else if (strikes > 0) {
                LightningInABottle.lightningStrike(p, target_entity, strikes - 1);
                p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
                p.playSound(p.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
            }
        } else {
            assert (target_block != null);
            if (target_block.getType() != Material.AIR) {
                if (Mana.manaConsume(p, mana_cost, name)) {
                    LightningInABottle.lightningStrike(target_block.getLocation(), strikes);
                    p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
                    p.playSound(p.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
                } else if (strikes > 0) {
                    LightningInABottle.lightningStrike(target_block.getLocation(), strikes - 1);
                    p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
                    p.playSound(p.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
                }
            } else {
                p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            }
        }
    }

    public static void lightningStrike(final Location loc, int strikes) {
        final BukkitScheduler scheduler = Bukkit.getScheduler();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                loc.getWorld().strikeLightning(loc);
                for (Entity entity : loc.getWorld().getNearbyEntities(loc, 3.0, 3.0, 3.0)) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity l = (LivingEntity)entity;
                    Stun.stunEntity(l, 100);
                }
            }
        };
        final int taskId = scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), task, 0L, 20L);
        scheduler.scheduleSyncDelayedTask((Plugin)UltraSkills.getPlugin(), new Runnable(){

            @Override
            public void run() {
                scheduler.cancelTask(taskId);
            }
        }, (long)strikes * 20L);
    }

    public static void lightningStrike(final Player p, final Entity e, long strikes) {
        final BukkitScheduler scheduler = Bukkit.getScheduler();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Location loc = e.getLocation();
                loc.getWorld().strikeLightning(loc);
                if (e.getType().equals((Object)EntityType.WITHER)) {
                    LivingEntity target = (LivingEntity)e;
                    target.damage(5.0, (Entity)p);
                }
                for (Entity entity : loc.getWorld().getNearbyEntities(loc, 3.0, 3.0, 3.0)) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity l = (LivingEntity)entity;
                    Stun.stunEntity(l, 100);
                }
            }
        };
        final int taskId = scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), task, 0L, 20L);
        scheduler.scheduleSyncDelayedTask((Plugin)UltraSkills.getPlugin(), new Runnable(){

            @Override
            public void run() {
                scheduler.cancelTask(taskId);
            }
        }, strikes * 20L);
    }

    public static void secondary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "lightning-stacks");
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) {
            p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
        }
        int stacks = (Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
        if (!Mana.manaConsume(p, mana_cost, name)) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        p.playSound(p.getLocation(), Sound.ITEM_BOTTLE_FILL_DRAGONBREATH, 1.0f, 1.0f);
        p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)(++stacks));
    }

    @EventHandler
    public void entityDamageEvent(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (e.getCause() == EntityDamageEvent.DamageCause.LIGHTNING && LightningInABottle.hasAbility(p)) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 200, 3));
            p.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 200, 3));
            p.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 200, 3));
        }
    }
}

