/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.material.Button;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class InvisibleHand
extends Talent {
    private static String name = "InvisibleHand";
    private static String description = "Wands: Named sticks are now wands. Right click to cycle spells and left click to cast. You start with one spell, Invisible Hand: from afar, you can open containers, flick switches/buttons/pressure plates, open doors, or punch entities for zero damage (mk2 punches do some damage and have extra knockback)";
    private static String tree = "Magic";
    private static int requiredLevel = 5;
    private static Material icon = Material.STICK;
    private static int slot = 5;

    public InvisibleHand() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new InvisibleHand(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        if (isSecondary) {
            InvisibleHand.secondary(e);
        } else {
            InvisibleHand.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!Mana.manaConsume(p, 0.25f, name)) {
            return;
        }
        Entity target_entity = p.getTargetEntity(100);
        Block target_block = p.getTargetBlock(100);
        if (target_entity instanceof LivingEntity) {
            if (Mana.manaConsume(p, 0.25f, name)) {
                ((LivingEntity)target_entity).damage(1.0, (Entity)p);
                p.playSound(target_entity.getLocation(), Sound.ENTITY_PLAYER_ATTACK_KNOCKBACK, 1.0f, 1.0f);
                p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_ATTACK_KNOCKBACK, 1.0f, 1.0f);
            }
        } else {
            assert (target_block != null);
            if (target_block.getType().equals((Object)Material.TORCH) || target_block.getType().equals((Object)Material.FIRE)) {
                p.playSound(p.getLocation(), Sound.BLOCK_CALCITE_HIT, 1.0f, 1.0f);
                target_block.breakNaturally();
            }
        }
    }

    public static void secondary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Block target_block = p.getTargetBlock(100);
        assert (target_block != null);
        if (target_block.getType().equals((Object)Material.CHEST)) {
            Chest chest = (Chest)target_block.getState();
            Inventory inventory = chest.getInventory();
            p.openInventory(inventory);
            chest.open();
            chest.close();
            p.playSound(p.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
        } else if (target_block.getType().equals((Object)Material.OAK_DOOR)) {
            Openable openable;
            BlockData data = target_block.getBlockData();
            openable.setOpen(!(openable = (Openable)data).isOpen());
            target_block.setBlockData(data);
            target_block.getState().update();
            p.playSound(p.getLocation(), Sound.BLOCK_WOODEN_DOOR_OPEN, 1.0f, 1.0f);
        } else if (target_block.getType().equals((Object)Material.STONE_BUTTON) || target_block.getType().equals((Object)Material.OAK_BUTTON)) {
            Button button;
            BlockData data = target_block.getBlockData();
            BlockState state = target_block.getState();
            button.setPowered(!(button = (Button)state.getData()).isPowered());
            state.setData((MaterialData)button);
            state.update();
        } else {
            p.playSound(p.getLocation(), Sound.BLOCK_CALCITE_HIT, 1.0f, 1.0f);
        }
    }
}

