/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.skillgroups.Magic;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class Illuminate
extends Talent {
    private static String name = "Illuminate";
    private static String description = "Left Click: Nearby players, mobs, and chests glow for 5 seconds. If you strike a mob directly, it will glow for 60 seconds.    Right Click: Place a torch at range.";
    private static String tree = "Magic";
    private static int requiredLevel = 15;
    private static Material icon = Material.TORCH;
    private static int slot = 15;
    private static float mana_cost = 0.5f;

    public Illuminate() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Illuminate(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        AbilityManager.putCooldown(e.getPlayer(), name, 50);
        if (isSecondary) {
            Illuminate.secondary(e);
        } else {
            Illuminate.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!Mana.manaConsume(p, 1.0f, name)) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        int lvl = Magic.getLevel(Magic.getXP(p));
        Entity target_entity = p.getTargetEntity(100);
        for (Entity entity : p.getNearbyEntities((double)(lvl * 2), (double)(lvl * 2), (double)(lvl * 2))) {
            if (entity.equals(target_entity)) {
                Illuminate.makeGlow(entity, 60L);
                p.playSound(p.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 1.0f);
                continue;
            }
            Illuminate.makeGlow(entity, 5L);
            p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
    }

    public static void secondary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Block target_block = p.getTargetBlock(100);
        if (target_block == null) {
            return;
        }
        Location target_loc = target_block.getLocation();
        BlockFace face = p.getTargetBlockFace(100);
        assert (face != null);
        Block torch_spot = target_block.getRelative(face);
        Location loc = torch_spot.getLocation();
        if (target_block.getType() == Material.SNOW) {
            torch_spot = target_block;
            torch_spot.setType(Material.AIR);
        }
        if (torch_spot.getType().equals((Object)Material.AIR) || torch_spot.getType().equals((Object)Material.SNOW)) {
            if (!Mana.manaConsume(p, mana_cost, name)) {
                p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
                return;
            }
            if (!Illuminate.placeTorch(torch_spot, face)) {
                p.playSound(p.getLocation(), Sound.BLOCK_CAMPFIRE_CRACKLE, 1.0f, 1.0f);
                return;
            }
            p.playSound(p.getLocation(), Sound.BLOCK_SHROOMLIGHT_PLACE, 1.0f, 1.0f);
        } else {
            p.playSound(p.getLocation(), Sound.BLOCK_CAMPFIRE_CRACKLE, 1.0f, 1.0f);
        }
    }

    public static boolean placeTorch(Block torch_spot, BlockFace face) {
        switch (face) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                torch_spot.setType(Material.WALL_TORCH);
                Directional torch = (Directional)Material.WALL_TORCH.createBlockData();
                torch.setFacing(face);
                torch_spot.setBlockData((BlockData)torch);
                return true;
            }
            case UP: {
                torch_spot.setType(Material.TORCH);
                return true;
            }
            case DOWN: {
                return false;
            }
        }
        return false;
    }

    public static void makeGlow(final Entity entity, long time) {
        entity.setGlowing(true);
        new BukkitRunnable(){

            public void run() {
                DebugUtility.consoleMessage(name + " removed from " + entity.getType(), 4);
                entity.setGlowing(false);
                this.cancel();
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), time * 20L, 20L);
    }
}

