/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import java.util.ArrayList;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.effects.Stun;
import me.ultra42.ultraskills.skillgroups.Magic;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class IceCapades
extends Talent {
    private static String name = "IceCapades";
    private static String description = "Left Click: Cast to apply the freeze effect on enemies near your target. This slows them and causes damage.    Right Click: Create a blizzard around you for 30 seconds. Freezes enemies in the area; mobs are turned into snowmen if they are killed by this; freezes water and turns lava into obsidian.";
    private static String tree = "Magic";
    private static int requiredLevel = 32;
    private static Material icon = Material.BLUE_ICE;
    private static int slot = 32;
    private static final float mana_cost_per_second = 0.05f;
    private static final float mana_cost_per_tick = 0.0025f;

    public IceCapades() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new IceCapades(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    private static boolean manaConsume(Player p, float mana_cost) {
        return Mana.manaConsume(p, mana_cost, name);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        if (isSecondary) {
            IceCapades.secondary(e);
        } else {
            IceCapades.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
    }

    public static void secondary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (p.hasPotionEffect(PotionEffectType.SLOW)) {
            p.removePotionEffect(PotionEffectType.SLOW);
        } else if (IceCapades.manaConsume(p, 1.0f)) {
            IceCapades.manaDrain(p, 0.01f);
            p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, Integer.MAX_VALUE, 0));
            p.playSound(p.getLocation(), Sound.WEATHER_RAIN_ABOVE, 1.0f, 1.0f);
        } else {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
        }
    }

    public static void manaDrain(final Player p, final float amount) {
        new BukkitRunnable(){

            public void run() {
                if (IceCapades.hasAbility(p) && p.hasPotionEffect(PotionEffectType.SLOW) && Mana.manaConsume(p, amount, name)) {
                    int range = (int)Math.round((double)Magic.getLevel(Magic.getXP(p)) * 0.5);
                    IceCapades.generateParticles(p, range);
                    IceCapades.freezeMobs(p, range);
                    IceCapades.frostWalker(p, range);
                } else {
                    p.removePotionEffect(PotionEffectType.SLOW);
                    this.cancel();
                }
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 4L);
    }

    public static void generateParticles(Player player, int radius) {
        Particle particleType = Particle.SNOWFLAKE;
        for (double y = 0.0; y <= Math.PI * 2; y += 0.1) {
            for (double x = 0.0; x <= Math.PI * 2; x += 0.1) {
                double xPos = Math.cos(y) * Math.sin(x) * (double)radius;
                double yPos = Math.cos(x) * (double)radius;
                double zPos = Math.sin(y) * Math.sin(x) * (double)radius;
                double randX = Math.random() * (double)radius * 2.0 - (double)radius;
                double randY = Math.random() * (double)radius * 2.0 - (double)radius;
                double randZ = Math.random() * (double)radius * 2.0 - (double)radius;
                player.getWorld().spawnParticle(particleType, player.getLocation().add(xPos + randX, yPos + randY, zPos + randZ), 0, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    public static void freezeMobs(final Player p, long range) {
        for (Entity e : p.getNearbyEntities((double)range, (double)range, (double)range)) {
            LivingEntity l;
            if (e instanceof LivingEntity && !e.getType().equals((Object)EntityType.SNOWMAN) && !e.getType().equals((Object)EntityType.STRAY) && !e.getType().equals((Object)EntityType.POLAR_BEAR)) {
                LivingEntity target = (LivingEntity)e;
                target.setFreezeTicks(Math.min(150, e.getFreezeTicks() + 40));
                if (target.getFreezeTicks() >= 140) {
                    Stun.stunEntity(target, 5);
                }
                if (target.getHealth() < 2.0) {
                    final Entity snowman = p.getWorld().spawnEntity(target.getLocation(), EntityType.SNOWMAN);
                    p.playSound(target.getLocation(), Sound.ITEM_BUCKET_FILL_POWDER_SNOW, 1.0f, 1.0f);
                    target.setHealth(0.0);
                    new BukkitRunnable(){

                        public void run() {
                            if (!p.hasPotionEffect(PotionEffectType.SLOW)) {
                                ((LivingEntity)snowman).setHealth(0.0);
                                this.cancel();
                            }
                            DebugUtility.consoleMessage(name);
                        }
                    }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 10L);
                }
            }
            if (!(e instanceof LivingEntity) || (l = (LivingEntity)e).getFireTicks() <= 0) continue;
            e.setFireTicks(0);
        }
        if (p.getFireTicks() > 0) {
            p.setFireTicks(0);
        }
    }

    public static void frostWalker(Player p, int range) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Location playerLocation = p.getLocation();
        int playerX = playerLocation.getBlockX();
        int playerY = playerLocation.getBlockY();
        int playerZ = playerLocation.getBlockZ();
        for (int x = 0 - (range /= 4); x <= 0 + range; ++x) {
            block1: for (int z = 0 - range; z <= 0 + range; ++z) {
                for (int y = -1; y <= 0; ++y) {
                    if (x * x + z * z > range * range) continue;
                    Block block = p.getWorld().getBlockAt(x + playerX, y + playerY, z + playerZ);
                    blocks.add(block);
                    if (!block.getRelative(BlockFace.UP).getType().equals((Object)Material.AIR)) continue block1;
                    if (block.getType().equals((Object)Material.WATER)) {
                        block.setType(Material.FROSTED_ICE);
                        continue;
                    }
                    if (!block.getType().equals((Object)Material.LAVA)) continue;
                    block.setType(Material.OBSIDIAN);
                }
            }
        }
    }

    @EventHandler
    public static void onPlayerMagmaDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!e.getCause().equals((Object)EntityDamageEvent.DamageCause.HOT_FLOOR)) {
            return;
        }
        if (IceCapades.hasAbility(p) && p.hasPotionEffect(PotionEffectType.SLOW)) {
            e.setCancelled(true);
            p.playSound(p.getLocation(), Sound.BLOCK_LAVA_EXTINGUISH, 1.0f, 1.0f);
        }
    }
}

