/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.entity.SmallFireball;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;

public class Fireball
extends Talent {
    private static String name = "Fireball";
    private static String description = "Shoot fireballs. ";
    private static String tree = "Magic";
    private static int requiredLevel = 25;
    private static Material icon = Material.FIRE_CHARGE;
    private static int slot = 25;
    private static float mana_cost = 1.0f;

    public Fireball() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Fireball(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        if (isSecondary) {
            Fireball.secondary(e);
        } else {
            Fireball.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!Mana.manaConsume(p, mana_cost, name)) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        Location loc = p.getEyeLocation().toVector().add(p.getLocation().getDirection().multiply(2)).toLocation(p.getWorld(), p.getLocation().getYaw(), p.getLocation().getPitch());
        org.bukkit.entity.Fireball fireball = (org.bukkit.entity.Fireball)p.getWorld().spawn(loc, org.bukkit.entity.Fireball.class);
        fireball.setVelocity(fireball.getVelocity().add(p.getVelocity()));
        fireball.setYield(2.0f);
        fireball.setShooter((ProjectileSource)p);
        p.playSound(p.getLocation(), Sound.ENTITY_GHAST_SHOOT, 1.0f, 0.25f);
    }

    public static void secondary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!Mana.manaConsume(p, 0.25f, name)) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        ((SmallFireball)p.launchProjectile(SmallFireball.class)).setVelocity(p.getLocation().getDirection().multiply(0.5));
        p.playSound(p.getLocation(), Sound.ENTITY_BLAZE_SHOOT, 1.0f, 1.0f);
    }
}

