/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.menusystem.menu.ConjureMenu;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Conjure
extends Talent {
    private static String name = "Conjure";
    private static String description = "Right click: create magical tools and spellcasting artifacts; items disappear if you drop them and cannot be placed; useful for summoning artifacts needed to cast other spells; active conjures reduce maximum mana (starting with wood/leather)";
    private static String tree = "Magic";
    private static int requiredLevel = 10;
    private static Material icon = Material.GOLDEN_AXE;
    private static int slot = 10;
    private static float mana_cost_per_second = 0.05f;
    private static float mana_cost_per_tick = mana_cost_per_second / 20.0f;

    public Conjure() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Conjure(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    private static boolean manaConsume(Player p, float mana_cost) {
        return Mana.manaConsume(p, mana_cost, name);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        if (isSecondary) {
            Conjure.secondary(e);
        } else {
            Conjure.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
    }

    public static void secondary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        new ConjureMenu(UltraSkills.getPlayerMenuUtility(p)).open(p);
    }

    public static void manaDrain(final Player p, final float amount) {
        new BukkitRunnable(){

            public void run() {
                if (Conjure.hasAbility(p) && p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                    float cost = amount * 4.0f;
                    if (p.isSprinting() || p.isFlying() || p.isJumping() || p.isSwimming()) {
                        cost *= 4.0f;
                    } else if (p.isSneaking() || p.isSleeping()) {
                        cost /= 4.0f;
                    }
                    if (!Mana.manaConsume(p, cost, name)) {
                        p.removePotionEffect(PotionEffectType.INVISIBILITY);
                        p.playSound(p.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
                        this.cancel();
                    }
                }
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 4L);
    }

    public static void loanMana(Player p, int amount) {
        int loan_mana;
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "loan_mana");
        if (!p.getPersistentDataContainer().has(key, PersistentDataType.INTEGER) || !AbilityManager.hasAbility(p, name)) {
            p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
        }
        if ((loan_mana = (Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER) + amount) < 0) {
            p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
            return;
        }
        p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)loan_mana);
    }

    public static void returnMana(Player p, int amount) {
        Conjure.loanMana(p, -1 * amount);
    }

    public static void returnMana(Player p) {
        Conjure.returnMana(p, Mana.getLoanMana(p));
    }

    public static void conjure(Player p, Material m, int cost) {
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "loan_mana");
        if (!Mana.manaConsume(p, cost, name) && p.getPersistentDataContainer().has(key) && (Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER) >= cost) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        ItemStack item = new ItemStack(m, 1);
        ItemMeta meta = item.getItemMeta();
        meta.addEnchant(Enchantment.VANISHING_CURSE, 1, true);
        meta.setDisplayName("CONJURED_" + m.toString());
        item.setItemMeta(meta);
        p.getInventory().addItem(new ItemStack[]{item});
        Conjure.loanMana(p, cost);
        p.playSound(p.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
        p.playSound(p.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
    }

    @EventHandler
    public static void onItemDrop(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        ItemStack i = e.getItemDrop().getItemStack();
        ItemMeta meta = i.getItemMeta();
        String name = meta.getDisplayName();
        if (name.startsWith("CONJURED_")) {
            Conjure.returnMana(p, ConjureMenu.getItemCost(i.getType()));
            i.setAmount(0);
            p.playSound(p.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
            p.playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        }
    }

    @EventHandler
    public static void onItemBreak(PlayerItemBreakEvent e) {
        Player p = e.getPlayer();
        ItemStack i = e.getBrokenItem();
        ItemMeta meta = i.getItemMeta();
        String name = meta.getDisplayName();
        if (name.startsWith("CONJURED_")) {
            Conjure.returnMana(p, ConjureMenu.getItemCost(i.getType()));
            i.setAmount(0);
            p.playSound(p.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
            p.playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        }
    }

    @EventHandler
    public static void onPlayerDeath(PlayerDeathEvent e) {
        Player p = e.getPlayer();
        if (!Conjure.hasAbility(p)) {
            return;
        }
        Conjure.returnMana(p);
    }
}

