/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.magic;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Mana;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Catalyst
extends Talent {
    private static String name = "Catalyst";
    private static String description = "Left Click: Cast on an entity to apply slowness and gain mana for doing so. Does not work on targets that already have slowness.   Right Click: Cast to augment your movement; gain levitation if jumping, slow falling if falling, jump boost if crouching, dolphin's grace if swimming, propulsion if flying.";
    private static String tree = "Magic";
    private static int requiredLevel = 23;
    private static Material icon = Material.FIREWORK_ROCKET;
    private static int slot = 23;
    private static float mana_cost_per_second = 0.5f;
    private static float mana_cost_per_tick = mana_cost_per_second / 20.0f;

    public Catalyst() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Catalyst(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    private static boolean manaConsume(Player p, float mana_cost) {
        return Mana.manaConsume(p, mana_cost, name);
    }

    public static void cast(PlayerInteractEvent e, boolean isSecondary) {
        if (isSecondary) {
            Catalyst.secondary(e);
        } else {
            Catalyst.primary(e);
        }
    }

    public static void primary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Entity entity = p.getTargetEntity(100);
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity target_entity = (LivingEntity)entity;
            if (target_entity.hasPotionEffect(PotionEffectType.SLOW)) {
                return;
            }
            if (!Mana.manaConsume(p, 1.0f, name)) {
                p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
                return;
            }
            target_entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 300, 1));
            p.playSound(p.getLocation(), Sound.WEATHER_RAIN, 1.0f, 1.0f);
            Mana.giveMana(p, 5.0f);
        }
    }

    public static void secondary(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!Mana.manaConsume(p, 1.0f, name)) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        if (p.isSprinting()) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 300, 0));
        }
        if (p.isSwimming()) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, 100, 0));
        } else if (p.isGliding()) {
            p.setVelocity(p.getEyeLocation().getDirection().normalize().multiply(2.0));
            p.playSound(p.getLocation(), Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, 1.0f, 1.0f);
        } else if (p.getVelocity().getY() > 0.0) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 40, 4));
        } else if (p.getVelocity().getY() < -0.1 && Catalyst.getBlocksInAir(p) > 8.0) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 80, 4));
        }
    }

    public static double getBlocksInAir(Player p) {
        Location playerLocation = p.getLocation();
        int playerHeight = playerLocation.getBlockY();
        Block currentBlock = playerLocation.getBlock();
        Block nearestNonAirBlock = null;
        while (currentBlock.getY() > 0) {
            if (currentBlock.getType() != Material.AIR) {
                nearestNonAirBlock = currentBlock;
                break;
            }
            currentBlock = currentBlock.getRelative(BlockFace.DOWN);
        }
        return p.getLocation().distance(nearestNonAirBlock.getLocation());
    }
}

