/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.general;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.Skill;
import me.ultra42.ultraskills.utilities.AbilityManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;

public class CloudStorage
extends Skill {
    public static Map<String, ItemStack[]> cloudInventories = new HashMap<String, ItemStack[]>();

    public Component getName() {
        return Component.text((String)"Cloud Storage");
    }

    public String getSkill_group() {
        return "General";
    }

    public Material getIcon() {
        return Material.ENDER_CHEST;
    }

    public ArrayList<String> getDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Gain access to an extra-dimensional");
        lore.add("vault for safe keeping. (1x9 row per");
        lore.add("skill point invested.)");
        return lore;
    }

    public int getRequiredLevel() {
        return 10;
    }

    public boolean isSecret() {
        return false;
    }

    public int getMaxRanks() {
        return 1;
    }

    public int getBaseCooldown() {
        return 0;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (!AbilityManager.hasAbility(e.getPlayer(), "CloudStorage")) {
            AbilityManager.putCooldown(e.getPlayer(), "CloudStorage", 0);
        }
    }

    @EventHandler
    public void onGUIClose(InventoryCloseEvent event) {
        String cloudName;
        String closedName = PlainTextComponentSerializer.plainText().serialize(event.getView().title());
        if (closedName.equals(cloudName = event.getPlayer().getName() + "'s Cloud")) {
            UltraSkills.getPlugin().getLogger().info("storing inventory");
            cloudInventories.put(event.getPlayer().getUniqueId().toString(), event.getInventory().getContents());
        }
    }

    public static void saveInvs() {
        for (Map.Entry<String, ItemStack[]> entry : cloudInventories.entrySet()) {
            UltraSkills.getData().getConfig().set("players." + entry.getKey() + ".CloudStorage", (Object)entry.getValue());
        }
        UltraSkills.getData().saveConfig();
    }

    public static void restoreInvs() {
        UltraSkills.getData().getConfig().getConfigurationSection("players").getKeys(false).forEach(key -> {
            if (UltraSkills.getData().getConfig().contains("players." + key + ".CloudStorage")) {
                ItemStack[] content = ((List)UltraSkills.getData().getConfig().get("players." + key + ".CloudStorage")).toArray(new ItemStack[0]);
                cloudInventories.put((String)key, content);
            }
        });
    }

    public static boolean open() {
        if (UltraSkills.getData().getConfig().contains("players")) {
            CloudStorage.restoreInvs();
            UltraSkills.getPlugin().getLogger().info("CloudStorage skill saved player's extra-dimensional inventories. Loaded successfully!");
            return true;
        }
        UltraSkills.getPlugin().getLogger().info("No saved inventories to load for CloudStorage skill.");
        return false;
    }

    public static boolean close() {
        if (!cloudInventories.isEmpty()) {
            CloudStorage.saveInvs();
            UltraSkills.getPlugin().getLogger().info("CloudStorage skill saved player's extra-dimensional inventories. Closed successfully!");
            return true;
        }
        UltraSkills.getPlugin().getLogger().info("No data to save for CloudStorage skill. Closed successfully.");
        return false;
    }
}

