/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.foraging;

import java.util.ArrayList;
import java.util.List;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Treecapitator
extends Talent {
    private static String name = "Treecapitator";
    private static String description = "Break entire trees when breaking a single log with an axe.";
    private static String tree = "Foraging";
    private static int requiredLevel = 42;
    private static Material icon = Material.STONE_AXE;
    private static int slot = 42;

    public Treecapitator() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Treecapitator(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        block5: {
            List<Block> logs;
            ItemStack tool;
            block6: {
                Player player = event.getPlayer();
                tool = player.getInventory().getItemInMainHand();
                Block block = event.getBlock();
                String type = block.getType().name();
                if (!Treecapitator.hasAbility(player) || !player.getGameMode().equals((Object)GameMode.SURVIVAL) || !tool.getType().name().endsWith("_AXE") || !type.endsWith("_LOG") || player.isSneaking()) break block5;
                if (type.startsWith("STRIPPED_")) {
                    type = type.substring(9);
                }
                logs = this.getLogs(block.getLocation(), type);
                logs.remove(block);
                if (!this.hasLeaves(logs, type.substring(0, type.length() - 4) + "_LEAVES")) break block6;
                Damageable meta = (Damageable)tool.getItemMeta();
                int dur = tool.getType().getMaxDurability() - meta.getDamage() - 1;
                if (logs.size() > dur) {
                    logs = logs.subList(0, dur);
                }
                meta.setDamage(meta.getDamage() + logs.size());
                tool.setItemMeta((ItemMeta)meta);
                for (Block log : logs) {
                    log.breakNaturally();
                }
                break block5;
            }
            if (!this.hasLeaves(logs, "AZALEA_LEAVES")) break block5;
            Damageable meta = (Damageable)tool.getItemMeta();
            int dur = tool.getType().getMaxDurability() - meta.getDamage() - 1;
            if (logs.size() > dur) {
                logs = logs.subList(0, dur);
            }
            meta.setDamage(meta.getDamage() + logs.size());
            tool.setItemMeta((ItemMeta)meta);
            for (Block log : logs) {
                log.breakNaturally();
            }
        }
    }

    public List<Block> getSurrounding(Location origin, String type) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = -1; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    Location loc = origin.clone().add((double)x, (double)y, (double)z);
                    Block block = loc.getBlock();
                    if (origin.equals((Object)loc) || !block.getType().name().endsWith(type)) continue;
                    blocks.add(block);
                }
            }
        }
        return blocks;
    }

    public List<Block> getLogs(Location origin, String type) {
        ArrayList<Block> logs = new ArrayList<Block>();
        List<Block> next = this.getSurrounding(origin, type);
        while (!next.isEmpty()) {
            ArrayList<Block> nextNext = new ArrayList<Block>();
            for (Block log : next) {
                if (logs.contains(log)) continue;
                logs.add(log);
                nextNext.addAll(this.getSurrounding(log.getLocation(), type));
            }
            next = nextNext;
        }
        return logs;
    }

    public boolean hasLeaves(List<Block> logs, String type) {
        for (Block log : logs) {
            if (this.getSurrounding(log.getLocation(), type).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

