/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.foraging;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class Phototropic
extends Talent {
    private static String name = "Phototropic";
    private static String description = "Restore hunger slowly while exposed to sunlight. Overflows into saturation.";
    private static String tree = "Foraging";
    private static int requiredLevel = 20;
    private static Material icon = Material.SUNFLOWER;
    private static int slot = 20;

    public Phototropic() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Phototropic(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Phototropic.scheduler();
    }

    public static void scheduler() {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), () -> {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                if (!Phototropic.hasAbility(p) || p.getLocation().getBlock().getLightFromSky() <= 11 || !p.getWorld().isDayTime() || p.getWorld().hasStorm()) continue;
                if (p.getFoodLevel() < 18) {
                    p.setFoodLevel(p.getFoodLevel() + 2);
                    Phototropic.indicators(p);
                    continue;
                }
                if (!(p.getSaturation() < (float)p.getFoodLevel())) continue;
                p.setSaturation(p.getSaturation() + 1.0f);
                Phototropic.indicators(p);
                if (p.getSaturation() != 20.0f) continue;
                p.sendMessage("You have fully absorbed the sun's energy.");
                p.playSound(p.getLocation(), Sound.AMBIENT_UNDERWATER_LOOP_ADDITIONS_RARE, 30.0f, 1.0f);
            }
        }, 0L, 80L);
    }

    public static void indicators(Player p) {
        for (int i = 0; i < 20; ++i) {
            p.spawnParticle(Particle.COMPOSTER, p.getEyeLocation(), 1, Math.random(), Math.random(), Math.random());
        }
    }
}

