/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.foraging;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.LootUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.noise.PerlinNoiseGenerator;

public class GoldPanning
extends Talent {
    private static String name = "GoldPanning";
    private static String description = "Pan for gold (and other valuables) by right-clicking a bowl on water-covered sand. Must be natural sand. Higher-pitched pings will direct you to richer deposits.";
    private static String tree = "Foraging";
    private static int requiredLevel = 7;
    private static Material icon = Material.BOWL;
    private static int slot = 7;

    public GoldPanning() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new GoldPanning(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block clickedBlock;
        Player player = event.getPlayer();
        Action action = event.getAction();
        ItemStack item = event.getItem();
        if (!GoldPanning.hasAbility(player)) {
            return;
        }
        if (!AbilityManager.isOffCooldown(player, name)) {
            return;
        }
        if (action == Action.RIGHT_CLICK_BLOCK && item != null && item.getType() == Material.BOWL && (clickedBlock = event.getClickedBlock()).getType() == Material.SAND) {
            Waterlogged waterlogged;
            Block facingBlock = clickedBlock.getRelative(event.getBlockFace());
            if (facingBlock.getType() == Material.WATER || facingBlock instanceof Waterlogged && (waterlogged = (Waterlogged)facingBlock).isWaterlogged()) {
                event.setCancelled(true);
                ItemStack result = this.getGoldPanningLoot(player, clickedBlock);
                if (result != null) {
                    LootUtility.sendItemToPlayerInventory(player, result);
                }
                AbilityManager.putCooldown(player, name, 500);
            } else {
                player.sendMessage("There is no water above the sand!");
            }
        }
    }

    public ItemStack getGoldPanningLoot(Player player, Block block) {
        int luckLevel = 0;
        for (PotionEffect effect : player.getActivePotionEffects()) {
            if (!effect.getType().equals((Object)PotionEffectType.LUCK)) continue;
            luckLevel = effect.getAmplifier() + 1;
            break;
        }
        double noise = this.getNoiseValue(block);
        double random = Math.random();
        double roll = random * noise;
        float pitch = 0.5f + 1.5f * (float)noise;
        String message = "Noise: " + String.format("%.3f", noise) + " | Roll: " + String.format("%.3f", roll) + " | " + GoldPanning.isFirstPan(player, block);
        DebugUtility.consoleMessage("[GoldPanning] " + message, 4);
        GoldPanning.panningSound(player, pitch, GoldPanning.isFirstPan(player, block));
        PersistentDataUtility.store(player, name, block.toString());
        if (random > 0.98) {
            block.breakNaturally();
        }
        if (roll > 0.9 - (double)luckLevel * 0.01) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 0.5f, 0.75f);
            return new ItemStack(Material.DIAMOND);
        }
        if (roll > 0.8 - (double)luckLevel * 0.02) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 0.5f, 1.0f);
            return new ItemStack(Material.EMERALD);
        }
        if (roll > 0.7 - (double)luckLevel * 0.03) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 0.5f, 1.25f);
            return new ItemStack(Material.RAW_GOLD);
        }
        if (roll > 0.6 - (double)luckLevel * 0.04) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 0.5f, 1.5f);
            return new ItemStack(Material.GOLD_NUGGET, (int)(Math.random() * 5.0 + 1.0));
        }
        if (roll > 0.5 - (double)luckLevel * 0.05) {
            return new ItemStack(Material.QUARTZ);
        }
        if (roll > 0.4) {
            return new ItemStack(Material.FLINT);
        }
        return null;
    }

    public double getNoiseValue(Block block) {
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        double amplitude = 1.0;
        double frequency = 0.01;
        double noiseValue = 0.0;
        PerlinNoiseGenerator generator = new PerlinNoiseGenerator(block.getWorld());
        double octaveValue = generator.noise((double)x * frequency, (double)y * frequency, (double)z * frequency) * 0.5 + 0.5;
        return noiseValue += octaveValue * amplitude;
    }

    public static void panningSound(final Player player, final float pitch, final boolean first) {
        final int[] count = new int[]{2};
        new BukkitRunnable(){

            public void run() {
                if (count[0] <= 0) {
                    if (first) {
                        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BIT, pitch, pitch);
                    }
                    this.cancel();
                } else {
                    player.playSound(player.getLocation(), Sound.BLOCK_ROOTED_DIRT_HIT, 0.4f, 0.7f);
                    count[0] = count[0] - 1;
                }
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 3L);
    }

    public static boolean isFirstPan(Player player, Block block) {
        return !PersistentDataUtility.readString((Entity)player, name, block.toString()).equals(block.toString());
    }
}

