/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.farming;

import java.util.EnumSet;
import java.util.Set;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.ubb.UltraBlock;
import me.ultra42.ultraskills.utilities.ubb.UltraBlockBreakEvent;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class Planter
extends Talent {
    private static String name = "Planter";
    private static String description = "Automatically replant when you harvest crops. Automatically harvest when you attempt to bone meal a crop that is already fully grown.";
    private static String tree = "Farming";
    private static int requiredLevel = 10;
    private static Material icon = Material.MELON_SEEDS;
    private static int slot = 10;
    public static Set<Material> BONE_MEAL_CROPS = EnumSet.of(Material.WHEAT, new Material[]{Material.CARROTS, Material.POTATOES, Material.BEETROOTS, Material.BAMBOO, Material.MELON_SEEDS, Material.PUMPKIN_SEEDS, Material.BAMBOO_SAPLING, Material.SPRUCE_SAPLING, Material.ACACIA_SAPLING, Material.BIRCH_SAPLING, Material.DARK_OAK_SAPLING, Material.JUNGLE_SAPLING, Material.OAK_SAPLING, Material.AZALEA, Material.FLOWERING_AZALEA, Material.MANGROVE_PROPAGULE, Material.SUNFLOWER, Material.LILAC, Material.ROSE_BUSH, Material.PEONY, Material.GRASS, Material.FERN, Material.SEAGRASS, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.COCOA, Material.SWEET_BERRY_BUSH, Material.SEA_PICKLE, Material.KELP, Material.CRIMSON_FUNGUS, Material.WARPED_FUNGUS, Material.WEEPING_VINES, Material.TWISTING_VINES, Material.CAVE_VINES, Material.GLOW_LICHEN, Material.BIG_DRIPLEAF, Material.SMALL_DRIPLEAF, Material.ROOTED_DIRT, Material.MANGROVE_LEAVES});

    public Planter() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Planter(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onBlockBreak(UltraBlockBreakEvent event) {
        BlockData bdata;
        Player player = event.getPlayer();
        final Block block = event.getBlock();
        final Material m = block.getType();
        if (Planter.hasAbility(player) && player.getGameMode().equals((Object)GameMode.SURVIVAL) && BONE_MEAL_CROPS.contains(m) && Planter.checkFullyGrown(block) && (bdata = block.getBlockData()) instanceof Ageable) {
            new BukkitRunnable(){

                public void run() {
                    block.setType(m);
                    Ageable age = (Ageable)bdata;
                    age.setAge(0);
                }
            }.runTaskLater((Plugin)UltraSkills.getPlugin(), 1L);
        }
    }

    @EventHandler
    public void onPlayerRightClick(PlayerInteractEvent e) {
        if (e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && (e.getHand().equals((Object)EquipmentSlot.HAND) && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.BONE_MEAL) || e.getHand().equals((Object)EquipmentSlot.OFF_HAND) && e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)Material.BONE_MEAL))) {
            BlockData bdata;
            final Block block = e.getClickedBlock();
            final Player player = e.getPlayer();
            final ItemStack tool = player.getInventory().getItemInMainHand();
            if (BONE_MEAL_CROPS.contains(block.getType()) && (bdata = block.getBlockData()) instanceof Ageable) {
                new BukkitRunnable(){

                    public void run() {
                        BlockData bdata = block.getBlockData();
                        Ageable age = (Ageable)bdata;
                        if (age.getAge() == age.getMaximumAge()) {
                            Material m = block.getType();
                            UltraBlock.breakBlock(block, player, tool);
                            block.setType(m);
                        }
                    }
                }.runTaskLater((Plugin)UltraSkills.getPlugin(), 1L);
            }
        }
    }

    @EventHandler
    public void onFertilizeEvent(BlockFertilizeEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        final Block block = event.getBlock();
        ItemStack tool = player.getInventory().getItemInMainHand();
        BlockData bdata = block.getBlockData();
        if (bdata instanceof Ageable) {
            new BukkitRunnable(){

                public void run() {
                    BlockData bdata = block.getBlockData();
                    Ageable age = (Ageable)bdata;
                    if (age.getAge() == age.getMaximumAge()) {
                        Material m = block.getType();
                        block.setType(m);
                    }
                }
            }.runTaskLater((Plugin)UltraSkills.getPlugin(), 1L);
        }
    }

    public static boolean checkFullyGrown(Block b) {
        Ageable age;
        BlockData bdata = b.getBlockData();
        return bdata instanceof Ageable && (age = (Ageable)bdata).getAge() == age.getMaximumAge();
    }

    public static void planterCheck(Player player, Block block) {
        if (Planter.hasAbility(player) && player.getGameMode().equals((Object)GameMode.SURVIVAL) && BONE_MEAL_CROPS.contains(block.getType()) && Planter.checkFullyGrown(block)) {
            Material m = block.getType();
            ItemStack tool = player.getInventory().getItemInMainHand();
            UltraBlock.breakBlock(block, player, tool);
            block.setType(m);
            BlockData bdata = block.getBlockData();
            Ageable age = (Ageable)bdata;
            age.setAge(0);
        }
    }
}

