/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.farming;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.farming.Planter;
import me.ultra42.ultraskills.skillgroups.SkillGroup;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class GreenThumb
extends Talent {
    private static String name = "GreenThumb";
    private static String description = "Roll to apply bone meal to nearby crops each second. Radius scales with farming level. The rolls get faster the longer you stay in the same area.";
    private static String tree = "Farming";
    private static int requiredLevel = 28;
    private static Material icon = Material.GREEN_CANDLE;
    private static int slot = 28;
    public static Set<Material> bone_meal_crops = EnumSet.of(Material.WHEAT, new Material[]{Material.CARROTS, Material.POTATOES, Material.BEETROOTS, Material.BAMBOO, Material.MELON_SEEDS, Material.PUMPKIN_SEEDS, Material.BAMBOO_SAPLING, Material.SPRUCE_SAPLING, Material.ACACIA_SAPLING, Material.BIRCH_SAPLING, Material.DARK_OAK_SAPLING, Material.JUNGLE_SAPLING, Material.OAK_SAPLING, Material.AZALEA, Material.FLOWERING_AZALEA, Material.MANGROVE_PROPAGULE, Material.SUNFLOWER, Material.LILAC, Material.ROSE_BUSH, Material.PEONY, Material.SEAGRASS, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.COCOA, Material.SWEET_BERRY_BUSH, Material.SEA_PICKLE, Material.KELP, Material.CRIMSON_FUNGUS, Material.WARPED_FUNGUS, Material.WEEPING_VINES, Material.TWISTING_VINES, Material.CAVE_VINES, Material.GLOW_LICHEN, Material.BIG_DRIPLEAF, Material.SMALL_DRIPLEAF, Material.ROOTED_DIRT, Material.MANGROVE_LEAVES});

    public GreenThumb() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new GreenThumb(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        GreenThumb.scheduler();
    }

    public static void scheduler() {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), () -> {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                if (!GreenThumb.hasAbility(p)) continue;
                int radius = SkillGroup.getLevel(p, tree) / 5;
                GreenThumb.growCrops(GreenThumb.getNearbyBlocks(p, radius), p);
            }
        }, 0L, 5L);
    }

    public static List<Block> getNearbyBlocks(Player p, int radius) {
        Location location = p.getLocation();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = location.getBlockX() - radius; x <= location.getBlockX() + radius; ++x) {
            for (int y = location.getBlockY() - radius; y <= location.getBlockY() + radius; ++y) {
                for (int z = location.getBlockZ() - radius; z <= location.getBlockZ() + radius; ++z) {
                    blocks.add(location.getWorld().getBlockAt(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static boolean checkFullyGrown(Block b) {
        Ageable age;
        BlockData bdata = b.getBlockData();
        return bdata instanceof Ageable && (age = (Ageable)bdata).getAge() == age.getMaximumAge();
    }

    public static int growCrops(List<Block> crops, Player p) {
        int count = 0;
        for (Block b : crops) {
            if (!bone_meal_crops.contains(b.getType())) continue;
            ++count;
            double roll = Math.random();
            if (!(roll >= 0.99)) continue;
            b.applyBoneMeal(BlockFace.DOWN);
            Planter.planterCheck(p, b);
        }
        return count;
    }
}

