/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.farming;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Combine
extends Talent {
    private static String name = "Combine";
    private static String description = "Crops you harvest go directly into your inventory.";
    private static String tree = "Farming";
    private static int requiredLevel = 5;
    private static Material icon = Material.WOODEN_HOE;
    private static int slot = 5;
    public static Set<Material> CROPS = EnumSet.of(Material.WHEAT, new Material[]{Material.CARROTS, Material.POTATOES, Material.BEETROOTS, Material.BAMBOO, Material.MELON_SEEDS, Material.PUMPKIN_SEEDS, Material.BAMBOO_SAPLING, Material.SPRUCE_SAPLING, Material.ACACIA_SAPLING, Material.BIRCH_SAPLING, Material.DARK_OAK_SAPLING, Material.JUNGLE_SAPLING, Material.OAK_SAPLING, Material.AZALEA, Material.FLOWERING_AZALEA, Material.MANGROVE_PROPAGULE, Material.SUNFLOWER, Material.LILAC, Material.ROSE_BUSH, Material.PEONY, Material.GRASS, Material.FERN, Material.SEAGRASS, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.COCOA, Material.SWEET_BERRY_BUSH, Material.SEA_PICKLE, Material.KELP, Material.CRIMSON_FUNGUS, Material.WARPED_FUNGUS, Material.WEEPING_VINES, Material.TWISTING_VINES, Material.CAVE_VINES, Material.GLOW_LICHEN, Material.BIG_DRIPLEAF, Material.SMALL_DRIPLEAF, Material.ROOTED_DIRT, Material.MANGROVE_LEAVES, Material.SUGAR_CANE, Material.CACTUS, Material.MELON, Material.PUMPKIN, Material.TALL_GRASS});

    public Combine() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Combine(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockDropItemEvent event) {
        Player player = event.getPlayer();
        if (!Combine.hasAbility(player)) {
            return;
        }
        if (!CROPS.contains(event.getBlockState().getType())) {
            return;
        }
        for (Item item : event.getItems()) {
            this.sendItemToPlayerInventory(player, item.getItemStack());
            item.remove();
        }
    }

    public void sendItemToPlayerInventory(Player player, ItemStack item) {
        PlayerInventory inventory = player.getInventory();
        HashMap remainingItems = inventory.addItem(new ItemStack[]{item});
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
        if (!remainingItems.isEmpty()) {
            for (ItemStack remainingItem : remainingItems.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), remainingItem);
            }
        }
    }
}

