/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.farming;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.croptrample.CropTrampleEvent;
import me.ultra42.ultraskills.utilities.pressureplate.PressurePlateEvent;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Careful
extends Talent {
    private static String name = "Careful";
    private static String description = "You no longer trample crops... or set off tripwires and pressure plates (crouch to intentionally trigger them).";
    private static String tree = "Farming";
    private static int requiredLevel = 15;
    private static Material icon = Material.LEATHER_BOOTS;
    private static int slot = 15;

    public Careful() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Careful(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onCropTrample(CropTrampleEvent e) {
        Entity entity = e.getTrampler();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!Careful.hasAbility(p)) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onPressurePlate(PressurePlateEvent e) {
        Player p;
        Entity entity;
        Block b = e.getBlock();
        if (e.getCause().equals((Object)PressurePlateEvent.PressCause.PLAYER) && (entity = e.getEntity()) instanceof Player && Careful.hasAbility(p = (Player)entity) && !p.isSneaking()) {
            e.setCancelled(true);
        }
    }
}

