/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.defense;

import java.time.Duration;
import java.time.Instant;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class ThickSkin
extends Talent {
    private long duration = 5L;
    private static String name = "ThickSkin";
    private static String description = "You are immune to lava/fire damage for 5 seconds (30s cooldown). You are entirely immune to fire ticks.";
    private static String tree = "Defense";
    private static int requiredLevel = 18;
    private static Material icon = Material.LAVA_BUCKET;
    private static int slot = 18;

    public ThickSkin() {
        super(name, description, tree, requiredLevel);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new ThickSkin(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    public static boolean isOnCooldown(Player p) {
        return AbilityManager.getCooldown(p, "ThickSkin").isAfter(Instant.now());
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, "ThickSkin");
    }

    public static long remainingCooldown(Player p) {
        return Duration.between(Instant.now(), AbilityManager.getCooldown(p, "ThickSkin")).getSeconds();
    }

    public static void offCooldownNotification(Player p) {
        p.sendMessage("You could go for a swim\u2014in lava!");
        p.playSound(p.getLocation(), Sound.BLOCK_ANCIENT_DEBRIS_FALL, 10.0f, 4.0f);
        for (int i = 0; i < 20; ++i) {
            p.spawnParticle(Particle.ASH, p.getEyeLocation(), 1, Math.random(), Math.random(), Math.random());
        }
    }

    @EventHandler
    public void entityDamageEvent(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (e.getCause() == EntityDamageEvent.DamageCause.LAVA || e.getCause() == EntityDamageEvent.DamageCause.FIRE || e.getCause() == EntityDamageEvent.DamageCause.HOT_FLOOR || e.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
            if (ThickSkin.hasAbility(p) && e.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
                e.setCancelled(true);
                p.setFireTicks(0);
            } else if (ThickSkin.hasAbility(p) && !ThickSkin.isOnCooldown(p)) {
                e.setCancelled(true);
                p.setFireTicks(0);
                p.sendMessage("The warmth is comforting, for now...");
                p.playSound(p.getLocation(), Sound.BLOCK_LAVA_EXTINGUISH, 10.0f, 4.0f);
                AbilityManager.putCooldown(p, "ThickSkin", this.getBaseCooldown() * 1000);
                BukkitScheduler scheduler = Bukkit.getScheduler();
                scheduler.runTaskLater((Plugin)UltraSkills.getPlugin(), () -> ThickSkin.offCooldownNotification(p), 20L * (long)this.getBaseCooldown());
            } else if (ThickSkin.hasAbility(p) && ThickSkin.remainingCooldown(p) > (long)this.getBaseCooldown() - this.duration) {
                e.setCancelled(true);
                p.setFireTicks(0);
            } else if (!ThickSkin.hasAbility(p) || ThickSkin.isOnCooldown(p)) {
                // empty if block
            }
        }
    }

    public int getBaseCooldown() {
        return 30;
    }
}

