/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.defense;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class SoulFood
extends Talent {
    private static String name = "SoulFood";
    private static String description = "Crouching drains hunger to restore health.";
    private static String tree = "Defense";
    private static int requiredLevel = 10;
    private static Material icon = Material.COOKED_CHICKEN;
    private static int slot = 10;

    public SoulFood() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new SoulFood(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler(ignoreCancelled=true)
    private void onSneakToggle(PlayerToggleSneakEvent e) {
        final Player p = e.getPlayer();
        if (SoulFood.hasAbility(p)) {
            new BukkitRunnable(){

                public void run() {
                    if (p.isSneaking()) {
                        if (p.getHealth() < p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() && (double)p.getFoodLevel() > 1.0) {
                            double newHealth = p.getHealth() + 2.0;
                            if (newHealth > p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()) {
                                newHealth = p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
                            }
                            p.setHealth(newHealth);
                            p.setFoodLevel(p.getFoodLevel() - 1);
                        }
                    } else {
                        this.cancel();
                    }
                    DebugUtility.consoleMessage(name);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 10L);
        }
    }
}

