/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.defense;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.effects.Stun;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class ShieldBash
extends Talent {
    private static String name = "ShieldBash";
    private static String description = "Punch things with a shield to stun.";
    private static String tree = "Defense";
    private static int requiredLevel = 12;
    private static Material icon = Material.SHIELD;
    private static int slot = 12;

    public ShieldBash() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new ShieldBash(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    private void onShieldAttack(EntityDamageByEntityEvent e) {
        Player p;
        Entity entity = e.getDamager();
        if (!(entity instanceof Player && ShieldBash.hasAbility(p = (Player)entity) && (entity = e.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)entity;
        ItemStack i = p.getInventory().getItemInMainHand();
        if (!i.getType().equals((Object)Material.SHIELD)) {
            return;
        }
        Stun.stunEntity(l, 60);
    }
}

