/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.defense;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;

public class Pride
extends Talent {
    private static String name = "Pride";
    private static String description = "Wearing gold amor provides regeneration, which turns into poison while below 5 hearts.";
    private static String tree = "Defense";
    private static int requiredLevel = 16;
    private static Material icon = Material.GOLDEN_CHESTPLATE;
    private static int slot = 16;

    public Pride() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Pride(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Pride.scheduler();
    }

    public static void scheduler() {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), () -> {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                if (!Pride.hasAbility(p)) continue;
                int num_golden_pieces = 0;
                if (p.getInventory().getHelmet() != null && p.getInventory().getHelmet().getType() == Material.GOLDEN_HELMET) {
                    ++num_golden_pieces;
                }
                if (p.getInventory().getChestplate() != null && p.getInventory().getChestplate().getType() == Material.GOLDEN_CHESTPLATE) {
                    ++num_golden_pieces;
                }
                if (p.getInventory().getLeggings() != null && p.getInventory().getLeggings().getType() == Material.GOLDEN_LEGGINGS) {
                    ++num_golden_pieces;
                }
                if (p.getInventory().getBoots() != null && p.getInventory().getBoots().getType() == Material.GOLDEN_BOOTS) {
                    ++num_golden_pieces;
                }
                if (num_golden_pieces > 0 && p.getHealth() >= 10.0) {
                    p.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 80, num_golden_pieces - 1));
                    continue;
                }
                if (num_golden_pieces <= 0 || !(p.getHealth() < 10.0)) continue;
                p.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 80, num_golden_pieces - 1));
            }
        }, 0L, 80L);
    }
}

