/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.defense;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import me.ultra42.ultraskills.abilities.Skill;
import me.ultra42.ultraskills.utilities.AbilityManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class GuardianAngel
extends Skill {
    public static Component getName() {
        return Component.text((String)"Guardian Angel");
    }

    public String getSkill_group() {
        return "Defense";
    }

    public static Material getIcon() {
        return Material.TOTEM_OF_UNDYING;
    }

    public static List<Component> getDescription() {
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add((Component)Component.text((String)"Taking more than 5 hearts of damage"));
        lore.add((Component)Component.text((String)"that would otherwise be fatal, survive"));
        lore.add((Component)Component.text((String)"with half a heart instead."));
        return lore;
    }

    public int getRequiredLevel() {
        return 20;
    }

    public boolean isSecret() {
        return false;
    }

    public int getMaxRanks() {
        return 1;
    }

    public int getBaseCooldown() {
        return 300;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (!AbilityManager.hasAbility(p, "Brawler")) {
            AbilityManager.putCooldown(p, "Brawler", 0);
        }
    }

    @EventHandler
    public void entityDamageEvent(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (e.getDamage() >= 10.0 && e.getFinalDamage() >= p.getHealth()) {
            if (AbilityManager.hasAbility(p, "Brawler") && AbilityManager.isOffCooldown(p, "Brawler")) {
                e.setCancelled(true);
                p.setHealth(1.0);
                p.sendMessage("You have been saved.");
                p.playSound(p.getLocation(), Sound.ITEM_GOAT_HORN_SOUND_1, 10.0f, 4.0f);
                AbilityManager.putCooldown(p, "Brawler", this.getBaseCooldown() * 1000);
            } else if (AbilityManager.hasAbility(p, "Brawler") && !AbilityManager.isOffCooldown(p, "Brawler")) {
                p.sendMessage("Guardian Angel cooldown remaining: " + Duration.between(Instant.now(), AbilityManager.getCooldown(p, "Brawler")).getSeconds() + "s");
            }
        }
    }
}

