/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.defense;

import java.util.List;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.airborne.Airborne;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GroundPound
extends Talent {
    private static String name = "GroundPound";
    private static String description = "Crouching while in the air makes you slam to the ground. Nearby entities are knocked back and receive damage based on your armor tier. If you land on something, you don't take fall damage.";
    private static String tree = "Defense";
    private static int requiredLevel = 14;
    private static Material icon = Material.ANVIL;
    private static int slot = 14;

    public GroundPound() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new GroundPound(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    private boolean containsLivingEntities(List<Entity> nearbyEntities) {
        for (Entity e : nearbyEntities) {
            if (!(e instanceof LivingEntity)) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!GroundPound.hasAbility(p)) {
            return;
        }
        if (!e.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL)) {
            return;
        }
        if (!this.containsLivingEntities(p.getNearbyEntities(2.0, 2.0, 2.0))) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onPlayerCrouchInAir(PlayerToggleSneakEvent e) {
        final Player p = e.getPlayer();
        if (!GroundPound.hasAbility(p)) {
            return;
        }
        if (!e.isSneaking() || !Airborne.isAirborne((Entity)p)) {
            return;
        }
        p.setVelocity(new Vector(0, 0, 0));
        p.playSound(p.getLocation(), Sound.ENTITY_CAMEL_DASH_READY, 1.0f, 1.0f);
        final int[] count = new int[]{0};
        new BukkitRunnable(){

            public void run() {
                if (!Airborne.isAirborne((Entity)p)) {
                    GroundPound.this.impactEffects(p, 0.02 * (double)count[0]);
                    GroundPound.this.knockbackMobs(p, 0.1 * (double)count[0]);
                    if (GroundPound.this.containsLivingEntities(p.getNearbyEntities(2.0, 2.0, 2.0))) {
                        GroundPound.this.playerBounce(p, 0.02 * (double)count[0]);
                    }
                    this.cancel();
                } else {
                    p.setVelocity(new Vector(0.0, p.getVelocity().getY() - 0.05, 0.0));
                    count[0] = count[0] + 1;
                }
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 1L);
    }

    public void createCircleParticles(Player player, double radius, Particle particle, int density) {
        Location loc = player.getLocation();
        for (double i = 0.0; i < 360.0; i += (double)density) {
            double angle = i * Math.PI / 180.0;
            double x = radius * Math.cos(angle);
            double z = radius * Math.sin(angle);
            loc.add(x, 0.0, z);
            player.getWorld().spawnParticle(particle, loc.getX() + x, loc.getY(), loc.getZ() + z, 1, 0.0, 0.0, 0.0, 0.0);
            loc.subtract(x, 0.0, z);
        }
    }

    private void playerBounce(Player p, double strength) {
        p.setVelocity(new Vector(0.0, strength, 0.0));
    }

    public void impactEffects(final Player p, final double strength) {
        p.playSound(p.getLocation(), Sound.ENTITY_GOAT_SCREAMING_RAM_IMPACT, 1.0f, 1.0f);
        final int[] count = new int[]{0};
        new BukkitRunnable(){

            public void run() {
                if (count[0] >= 10) {
                    this.cancel();
                } else {
                    GroundPound.this.createCircleParticles(p, strength * (double)count[0], Particle.CLOUD, 10);
                    count[0] = count[0] + 1;
                }
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 0L, 1L);
    }

    public void knockbackMobs(Player p, double strength) {
        for (Entity e : p.getNearbyEntities(5.0, 3.0, 5.0)) {
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity l = (LivingEntity)e;
            Vector direction = l.getLocation().subtract(p.getLocation()).toVector();
            double damage_amount = 1.0 / direction.length() * strength;
            DebugUtility.consoleMessage(name + " Damage amount: " + damage_amount);
            l.damage(damage_amount);
            direction.add(new Vector(0.0, 0.3, 0.0));
            direction.multiply(1.0 / direction.length());
            direction.multiply(strength);
            l.setVelocity(direction);
        }
    }
}

