/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.defense;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class DeathRattle
extends Talent {
    private static String name = "DeathRattle";
    private static String description = "Explode on death, with power scaling with your maximum health at time of death.";
    private static String tree = "Defense";
    private static int requiredLevel = 24;
    private static Material icon = Material.TNT;
    private static int slot = 24;

    public DeathRattle() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new DeathRattle(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void entityDeathEvent(EntityDeathEvent e) {
        if (e.isCancelled()) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player p = (Player)livingEntity;
        if (DeathRattle.hasAbility(p)) {
            e.getEntity().getLocation().createExplosion((float)p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), false, false);
        }
    }
}

