/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.defense;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class BlockChain
extends Talent {
    private static String name = "BlockChain";
    private static String description = "Each piece of chainmail blocks 25% of projectiles from hitting you (100% with full set)";
    private static String tree = "Defense";
    private static int requiredLevel = 20;
    private static Material icon = Material.CHAINMAIL_CHESTPLATE;
    private static int slot = 20;

    public BlockChain() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new BlockChain(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void entityDamageEvent(ProjectileHitEvent e) {
        double block_chance;
        double roll;
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getHitEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!BlockChain.hasAbility(p)) {
            return;
        }
        int num_chainmail_pieces = 0;
        if (p.getInventory().getHelmet() != null && p.getInventory().getHelmet().getType() == Material.CHAINMAIL_HELMET) {
            ++num_chainmail_pieces;
        }
        if (p.getInventory().getChestplate() != null && p.getInventory().getChestplate().getType() == Material.CHAINMAIL_CHESTPLATE) {
            ++num_chainmail_pieces;
        }
        if (p.getInventory().getLeggings() != null && p.getInventory().getLeggings().getType() == Material.CHAINMAIL_LEGGINGS) {
            ++num_chainmail_pieces;
        }
        if (p.getInventory().getBoots() != null && p.getInventory().getBoots().getType() == Material.CHAINMAIL_BOOTS) {
            ++num_chainmail_pieces;
        }
        if ((roll = Math.random()) <= (block_chance = 0.25 * (double)num_chainmail_pieces)) {
            e.setCancelled(true);
            p.playSound((Entity)p, Sound.ITEM_ARMOR_EQUIP_CHAIN, 1.0f, 1.0f);
        }
    }
}

