/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.crafting;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Unchained
extends Talent {
    private static String name = "Unchained";
    private static String description = "Chainmail armor can be crafted with chains.";
    private static String tree = "Crafting";
    private static int requiredLevel = 20;
    private static Material icon = Material.CHAIN;
    private static int slot = 20;

    public Unchained() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Unchained(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Bukkit.addRecipe((Recipe)Unchained.getHelmetRecipe());
        Bukkit.addRecipe((Recipe)Unchained.getChestplateRecipe());
        Bukkit.addRecipe((Recipe)Unchained.getLeggingsRecipe());
        Bukkit.addRecipe((Recipe)Unchained.getBootsRecipe());
    }

    public static boolean recipeEquals(Recipe recipe) {
        ShapedRecipe sr1 = (ShapedRecipe)recipe;
        ShapedRecipe sr2 = (ShapedRecipe)Unchained.getHelmetRecipe();
        ShapedRecipe sr3 = (ShapedRecipe)Unchained.getChestplateRecipe();
        ShapedRecipe sr4 = (ShapedRecipe)Unchained.getLeggingsRecipe();
        ShapedRecipe sr5 = (ShapedRecipe)Unchained.getBootsRecipe();
        return sr1.key().equals(sr2.key()) || sr1.key().equals(sr3.key()) || sr1.key().equals(sr4.key()) || sr1.key().equals(sr5.key());
    }

    public static Recipe getHelmetRecipe() {
        ItemStack item = new ItemStack(Material.CHAINMAIL_HELMET, 1);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_chainmail_helmet"), item);
        recipe.shape(new String[]{"CCC", "C C", "   "});
        recipe.setIngredient('C', Material.CHAIN);
        return recipe;
    }

    public static Recipe getChestplateRecipe() {
        ItemStack item = new ItemStack(Material.CHAINMAIL_CHESTPLATE, 1);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_chainmail_chestplate"), item);
        recipe.shape(new String[]{"C C", "CCC", "CCC"});
        recipe.setIngredient('C', Material.CHAIN);
        return recipe;
    }

    public static Recipe getLeggingsRecipe() {
        ItemStack item = new ItemStack(Material.CHAINMAIL_LEGGINGS, 1);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_chainmail_leggings"), item);
        recipe.shape(new String[]{"CCC", "C C", "C C"});
        recipe.setIngredient('C', Material.CHAIN);
        return recipe;
    }

    public static Recipe getBootsRecipe() {
        ItemStack item = new ItemStack(Material.CHAINMAIL_BOOTS, 1);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_chainmail_boots"), item);
        recipe.shape(new String[]{"   ", "C C", "C C"});
        recipe.setIngredient('C', Material.CHAIN);
        return recipe;
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ShapedRecipe sr;
        Recipe recipe = e.getRecipe();
        if (recipe instanceof ShapedRecipe && Unchained.recipeEquals((Recipe)(sr = (ShapedRecipe)recipe)) && !Unchained.hasAbility((Player)e.getWhoClicked())) {
            e.getWhoClicked().sendMessage("You must have the " + tree + " skill " + name + " (lvl " + requiredLevel + ")");
            e.setResult(Event.Result.DENY);
        }
    }
}

