/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.crafting;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class StarForge
extends Talent {
    private static String name = "StarForge";
    private static String description = "Nether star can be crafted with a wither skulls, four ghast tears, and four fire charges.";
    private static String tree = "Crafting";
    private static int requiredLevel = 48;
    private static Material icon = Material.NETHER_STAR;
    private static int slot = 48;

    public StarForge() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new StarForge(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Bukkit.addRecipe((Recipe)StarForge.getRecipe());
    }

    public static boolean recipeEquals(Recipe recipe) {
        ShapedRecipe sr1 = (ShapedRecipe)recipe;
        ShapedRecipe sr2 = (ShapedRecipe)StarForge.getRecipe();
        return sr1.key().equals(sr2.key());
    }

    public static Recipe getRecipe() {
        ItemStack item = new ItemStack(Material.NETHER_STAR, 1);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_nether_star"), item);
        recipe.shape(new String[]{"FGF", "GWG", "FGF"});
        recipe.setIngredient('F', Material.FIRE_CHARGE);
        recipe.setIngredient('G', Material.GHAST_TEAR);
        recipe.setIngredient('W', Material.WITHER_SKELETON_SKULL);
        return recipe;
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ShapedRecipe sr;
        Recipe recipe = e.getRecipe();
        if (recipe instanceof ShapedRecipe && StarForge.recipeEquals((Recipe)(sr = (ShapedRecipe)recipe)) && !StarForge.hasAbility((Player)e.getWhoClicked())) {
            e.getWhoClicked().sendMessage("You must have the " + tree + " skill " + name + " (lvl " + requiredLevel + ")");
            e.setResult(Event.Result.DENY);
        }
    }
}

