/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.crafting;

import java.util.ArrayList;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class SandCastle
extends Talent {
    private static String name = "SandCastle";
    private static String description = "Make concrete powder out of just sand.";
    private static String tree = "Crafting";
    private static int requiredLevel = 2;
    private static Material icon = Material.YELLOW_CONCRETE_POWDER;
    private static int slot = 2;

    public SandCastle() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new SandCastle(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        SandCastle.getRecipes();
    }

    public static boolean recipeEquals(Recipe recipe) {
        ShapedRecipe sr1 = (ShapedRecipe)recipe;
        for (Recipe r : SandCastle.getRecipes()) {
            ShapedRecipe sr2 = (ShapedRecipe)r;
            if (!sr1.key().equals(sr2.key())) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<Recipe> getRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        return recipes;
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ShapedRecipe sr;
        Recipe recipe = e.getRecipe();
        if (recipe instanceof ShapedRecipe && SandCastle.recipeEquals((Recipe)(sr = (ShapedRecipe)recipe)) && !SandCastle.hasAbility((Player)e.getWhoClicked())) {
            e.getWhoClicked().sendMessage("You must have the " + tree + " skill " + name + " (lvl " + requiredLevel + ")");
            e.setResult(Event.Result.DENY);
        }
    }
}

