/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.crafting;

import java.util.HashMap;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class NoTimeToDye
extends Talent {
    private static String name = "NoTimeToDye";
    private static String description = "Put dye in the crafting table to cycle through all colors.";
    private static String tree = "Crafting";
    private static int requiredLevel = 7;
    private static Material icon = Material.WHITE_DYE;
    private static int slot = 7;
    static HashMap<Material, Material> dyeCraftingRotation = new HashMap();

    public NoTimeToDye() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new NoTimeToDye(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        NoTimeToDye.createDyeOrder();
        dyeCraftingRotation.forEach((key, value) -> Bukkit.addRecipe((Recipe)NoTimeToDye.getRecipe(key)));
    }

    public static boolean recipeEquals(Recipe recipe) {
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe sr1 = (ShapelessRecipe)recipe;
            ShapelessRecipe sr2 = (ShapelessRecipe)NoTimeToDye.getRecipe(sr1.getResult().getType());
            return sr1.key().equals(sr2.key());
        }
        return false;
    }

    public static Recipe getRecipe(Material key) {
        Material next_dye = NoTimeToDye.getNextDye(key);
        ItemStack item = new ItemStack(next_dye, 1);
        ShapelessRecipe recipe = new ShapelessRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_" + next_dye.name()), item);
        recipe.addIngredient(1, key);
        return recipe;
    }

    public static void createDyeOrder() {
        dyeCraftingRotation.put(Material.RED_DYE, Material.ORANGE_DYE);
        dyeCraftingRotation.put(Material.ORANGE_DYE, Material.YELLOW_DYE);
        dyeCraftingRotation.put(Material.YELLOW_DYE, Material.LIME_DYE);
        dyeCraftingRotation.put(Material.LIME_DYE, Material.GREEN_DYE);
        dyeCraftingRotation.put(Material.GREEN_DYE, Material.CYAN_DYE);
        dyeCraftingRotation.put(Material.CYAN_DYE, Material.BLUE_DYE);
        dyeCraftingRotation.put(Material.BLUE_DYE, Material.LIGHT_BLUE_DYE);
        dyeCraftingRotation.put(Material.LIGHT_BLUE_DYE, Material.WHITE_DYE);
        dyeCraftingRotation.put(Material.WHITE_DYE, Material.LIGHT_GRAY_DYE);
        dyeCraftingRotation.put(Material.LIGHT_GRAY_DYE, Material.GRAY_DYE);
        dyeCraftingRotation.put(Material.GRAY_DYE, Material.BLACK_DYE);
        dyeCraftingRotation.put(Material.BLACK_DYE, Material.BROWN_DYE);
        dyeCraftingRotation.put(Material.BROWN_DYE, Material.PINK_DYE);
        dyeCraftingRotation.put(Material.PINK_DYE, Material.MAGENTA_DYE);
        dyeCraftingRotation.put(Material.MAGENTA_DYE, Material.PURPLE_DYE);
        dyeCraftingRotation.put(Material.PURPLE_DYE, Material.RED_DYE);
    }

    public static Material getNextDye(Material dye) {
        return dyeCraftingRotation.get(dye);
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ShapedRecipe sr;
        Recipe recipe = e.getRecipe();
        if (recipe instanceof ShapedRecipe && NoTimeToDye.recipeEquals((Recipe)(sr = (ShapedRecipe)recipe)) && !NoTimeToDye.hasAbility((Player)e.getWhoClicked())) {
            e.getWhoClicked().sendMessage("You must have the " + tree + " skill " + name + " (lvl " + requiredLevel + ")");
            e.setResult(Event.Result.DENY);
        }
    }
}

