/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.crafting;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class MobBoss
extends Talent {
    private static String name = "Mob boss";
    private static String description = "Mob spawners can be crafted by surrounding a soul campfire in iron bars. Right click them with mob spawn eggs to set the type.";
    private static String tree = "Crafting";
    private static int requiredLevel = 42;
    private static Material icon = Material.SPAWNER;
    private static int slot = 42;

    public MobBoss() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new MobBoss(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Bukkit.addRecipe((Recipe)MobBoss.getRecipe());
    }

    public static boolean recipeEquals(Recipe recipe) {
        ShapedRecipe sr1 = (ShapedRecipe)recipe;
        ShapedRecipe sr2 = (ShapedRecipe)MobBoss.getRecipe();
        return sr1.key().equals(sr2.key());
    }

    public static Recipe getRecipe() {
        ItemStack item = new ItemStack(Material.SPAWNER, 1);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_spawner"), item);
        recipe.shape(new String[]{"III", "ISI", "III"});
        recipe.setIngredient('I', Material.IRON_BARS);
        recipe.setIngredient('S', Material.SOUL_CAMPFIRE);
        return recipe;
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ShapedRecipe sr;
        Recipe recipe = e.getRecipe();
        if (recipe instanceof ShapedRecipe && MobBoss.recipeEquals((Recipe)(sr = (ShapedRecipe)recipe)) && !MobBoss.hasAbility((Player)e.getWhoClicked())) {
            e.getWhoClicked().sendMessage("You must have the " + tree + " skill " + name + " (lvl " + requiredLevel + ")");
            e.setResult(Event.Result.DENY);
        }
    }
}

