/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.crafting;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class LabelMaker
extends Talent {
    private static String name = "LabelMaker";
    private static String description = "Name tags can be crafted with paper and ink.";
    private static String tree = "Crafting";
    private static int requiredLevel = 16;
    private static Material icon = Material.NAME_TAG;
    private static int slot = 16;

    public LabelMaker() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new LabelMaker(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Bukkit.addRecipe((Recipe)LabelMaker.getRecipe());
    }

    public static boolean recipeEquals(Recipe recipe) {
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe sr1 = (ShapelessRecipe)recipe;
            ShapelessRecipe sr2 = (ShapelessRecipe)LabelMaker.getRecipe();
            return sr1.key().equals(sr2.key());
        }
        return false;
    }

    public static Recipe getRecipe() {
        ItemStack item = new ItemStack(Material.NAME_TAG, 1);
        ShapelessRecipe recipe = new ShapelessRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_name_tag"), item);
        recipe.addIngredient(1, Material.PAPER);
        recipe.addIngredient(1, Material.INK_SAC);
        return recipe;
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ShapedRecipe sr;
        Recipe recipe = e.getRecipe();
        if (recipe instanceof ShapedRecipe && LabelMaker.recipeEquals((Recipe)(sr = (ShapedRecipe)recipe)) && !LabelMaker.hasAbility((Player)e.getWhoClicked())) {
            e.getWhoClicked().sendMessage("You must have the " + tree + " skill " + name + " (lvl " + requiredLevel + ")");
            e.setResult(Event.Result.DENY);
        }
    }
}

