/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.crafting;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class FalseIdols
extends Talent {
    private static String name = "FalseIdols";
    private static String description = "Craft the Totem of Undying (gold block U, emerald top center, enchanted golden apple in center). You can also use a regular golden apple, but this only has a 50% chance of saving your life.";
    private static String tree = "Crafting";
    private static int requiredLevel = 44;
    private static Material icon = Material.TOTEM_OF_UNDYING;
    private static int slot = 44;

    public FalseIdols() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new FalseIdols(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Bukkit.addRecipe((Recipe)FalseIdols.getRecipe());
    }

    public static boolean recipeEquals(Recipe recipe) {
        ShapedRecipe sr1 = (ShapedRecipe)recipe;
        ShapedRecipe sr2 = (ShapedRecipe)FalseIdols.getRecipe();
        return sr1.key().equals(sr2.key());
    }

    public static Recipe getRecipe() {
        ItemStack item = new ItemStack(Material.TOTEM_OF_UNDYING, 1);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_totem_of_undying"), item);
        recipe.shape(new String[]{"GEG", "GAG", "GGG"});
        recipe.setIngredient('G', Material.GOLD_BLOCK);
        recipe.setIngredient('E', Material.EMERALD_BLOCK);
        recipe.setIngredient('A', Material.ENCHANTED_GOLDEN_APPLE);
        return recipe;
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ShapedRecipe sr;
        Recipe recipe = e.getRecipe();
        if (recipe instanceof ShapedRecipe && FalseIdols.recipeEquals((Recipe)(sr = (ShapedRecipe)recipe)) && !FalseIdols.hasAbility((Player)e.getWhoClicked())) {
            e.getWhoClicked().sendMessage("You must have the " + tree + " skill " + name + " (lvl " + requiredLevel + ")");
            e.setResult(Event.Result.DENY);
        }
    }
}

