/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.crafting;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Endgame
extends Talent {
    private static String name = "Endgame";
    private static String description = "End portal frames can be crafted with six end stone and two dark prismarine.";
    private static String tree = "Crafting";
    private static int requiredLevel = 50;
    private static Material icon = Material.END_PORTAL_FRAME;
    private static int slot = 50;

    public Endgame() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Endgame(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        Bukkit.addRecipe((Recipe)Endgame.getRecipe());
    }

    public static boolean recipeEquals(Recipe recipe) {
        ShapedRecipe sr1 = (ShapedRecipe)recipe;
        ShapedRecipe sr2 = (ShapedRecipe)Endgame.getRecipe();
        return sr1.key().equals(sr2.key());
    }

    public static Recipe getRecipe() {
        ItemStack item = new ItemStack(Material.END_PORTAL_FRAME, 1);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "synthetic_end_portal_frame"), item);
        recipe.shape(new String[]{"D D", "EEE", "EEE"});
        recipe.setIngredient('D', Material.DARK_PRISMARINE);
        recipe.setIngredient('E', Material.END_STONE);
        return recipe;
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        ShapedRecipe sr;
        Recipe recipe = e.getRecipe();
        if (recipe instanceof ShapedRecipe && Endgame.recipeEquals((Recipe)(sr = (ShapedRecipe)recipe)) && !Endgame.hasAbility((Player)e.getWhoClicked())) {
            e.getWhoClicked().sendMessage("You must have the " + tree + " skill " + name + " (lvl " + requiredLevel + ")");
            e.setResult(Event.Result.DENY);
        }
    }
}

