/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import java.util.EnumSet;
import java.util.Set;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SugarRush
extends Talent {
    private static String name = "SugarRush";
    private static String description = "Consume sweets to gain jump boost and speed.";
    private static String tree = "Agility";
    private static int requiredLevel = 5;
    private static Material icon = Material.SUGAR;
    private static int slot = 5;
    public static Set<Material> sweets = EnumSet.of(Material.COOKIE, new Material[]{Material.GOLDEN_APPLE, Material.GOLDEN_CARROT, Material.HONEY_BOTTLE, Material.PUMPKIN_PIE, Material.CAKE, Material.SWEET_BERRIES, Material.GLOW_BERRIES});

    public SugarRush() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new SugarRush(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void playerEatItem(PlayerItemConsumeEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (SugarRush.hasAbility(p) && sweets.contains(e.getItem().getType())) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 600, 1));
            p.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 600, 3));
        }
    }
}

