/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Submarine
extends Talent {
    private static String name = "Submarine";
    private static String description = "While looking down and moving in a boat, crouching makes you submerge; while underwater in the boat, you get waterbreathing and night vision; slowly float up while not submerging.";
    private static String tree = "Agility";
    private static int requiredLevel = 28;
    private static Material icon = Material.BARREL;
    private static int slot = 28;

    public Submarine() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Submarine(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onExitBoat(VehicleExitEvent e) {
        if (!(e.getVehicle() instanceof Boat) || !(e.getExited() instanceof Player)) {
            return;
        }
        final Boat boat = (Boat)e.getVehicle();
        final Player p = (Player)e.getExited();
        if (!Submarine.hasAbility(p)) {
            return;
        }
        if (boat.isUnderWater()) {
            e.setCancelled(true);
            return;
        }
        if (boat.isOnGround()) {
            return;
        }
        if (boat.isInWater() && Math.abs(p.getVelocity().getX()) + Math.abs(p.getVelocity().getZ()) == 0.0) {
            return;
        }
        e.setCancelled(true);
        if (boat.isInWater() && AbilityManager.isOffCooldown(p, name) && !this.lookingAboveHorizon(p)) {
            boat.setGravity(false);
            boat.setVelocity(new Vector(0, -1, 0));
            AbilityManager.putCooldown(p, name, 1000);
            p.playSound(p.getLocation(), Sound.ENTITY_BOAT_PADDLE_WATER, 1.0f, 4.0f);
            new BukkitRunnable(){

                public void run() {
                    if (boat.isDead() || boat.getPassengers().isEmpty()) {
                        this.cancel();
                    }
                    double height = boat.getLocation().getY();
                    if (p.isSneaking()) {
                        height -= 4.0;
                        p.playSound(boat.getLocation(), Sound.BLOCK_BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, 0.25f, 1.0f);
                    } else if (boat.isUnderWater()) {
                        height += 2.0;
                    } else {
                        boat.setGravity(true);
                        this.cancel();
                    }
                    Submarine.this.setBoatVelocity(boat, height);
                    p.setRemainingAir(300);
                    p.setMaximumAir(300);
                    DebugUtility.consoleMessage(name);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 10L, 1L);
        } else if (!boat.isInWater() && AbilityManager.isOffCooldown(p, name) && p.getEyeLocation().getBlock().isPassable()) {
            boat.setGravity(true);
        }
    }

    @EventHandler
    public void onBoatMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (!Submarine.hasAbility(p)) {
            return;
        }
        if (!p.isInsideVehicle()) {
            return;
        }
        Boat boat = (Boat)p.getVehicle();
        assert (boat != null);
        if (boat.isUnderWater()) {
            boat.setGravity(false);
        }
    }

    public void setBoatVelocity(Boat boat, double yLevel) {
        Location boatLocation = boat.getLocation();
        Vector boatVelocity = boat.getLocation().getDirection().normalize();
        Player p = (Player)boat.getPassengers().get(0);
        if (!p.isSprinting()) {
            boatVelocity.multiply(0.1);
        }
        double distance = yLevel - boatLocation.getY();
        boatVelocity.setY(distance / 20.0);
        boat.setVelocity(boatVelocity);
    }

    public boolean lookingAboveHorizon(Player p) {
        Vector playerDirection = p.getEyeLocation().getDirection();
        double horizonAngle = Math.atan2(playerDirection.getY(), Math.sqrt(Math.pow(playerDirection.getX(), 2.0) + Math.pow(playerDirection.getZ(), 2.0)));
        return horizonAngle > 0.0;
    }

    @EventHandler
    public void onSuffocateDiving(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!e.getCause().equals((Object)EntityDamageEvent.DamageCause.SUFFOCATION)) {
            return;
        }
        if (!e.getEntity().isInsideVehicle()) {
            return;
        }
        if (!Submarine.hasAbility(p)) {
            return;
        }
        e.setCancelled(true);
        e.setDamage(0.0);
        Entity entity2 = p.getVehicle();
        if (entity2 instanceof Boat) {
            Boat boat = (Boat)entity2;
            boat.setVelocity(new Vector(0, -1, 0));
        }
    }
}

